function md=iceprognostic_wrapper(md);
%ICEPROGNOSTIC_WRAPPER - wrapper of the prognostic solution
%
%   prognostic wrapper for prognostic matlab driven solution. 
%   we need a wrapper so that we can launch the prognostic solution using Matlab parallel, 
%
%   Usage:
%      md=iceprognostic_wrapper(md);

%start timing
t1=clock;

%If running in parallel, launch core prognostic routine within a parallel job.
if strcmpi(md.cluster,'yes'),
	sched = findResource('scheduler', 'configuration', md.scheduler_configuration);
	pjob = createParallelJob(sched);
	set(pjob, 'FileDependencies', {'iceprognostic.m'});
	set(pjob, 'MaximumNumberOfWorkers', md.np); set(pjob, 'MinimumNumberOfWorkers', md.np);
	t = createTask(pjob, @iceprognostic, 1, {md});
	set(t, 'CaptureCommandWindowOutput', true)
	disp('   Submitting job to cluster');
	submit(pjob);
	waitForState(pjob);
	get(t, 'CommandWindowOutput')
	get(t,'ErrorMessage')
	disp('   Done running on cluster');
else
	md=iceprognostic(md);
end

%stop timing
t2=clock;

disp(sprintf('\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']));
