function dh1dh2dh3_basic=GetNodalFunctionsDerivativesBasic(triaelem,xyz_list,gauss_l1l2l3)
%GETNODALFUNCTIONSDERIVATIVESBASIC - return the values of the nodal functions derivatives on the current element
%
%   Usage:
%      dh1dh2dh3_basic=GetNodalFunctionsDerivativesBasic(triaelem,xyz_list,gauss_l1l2l3)
%
%   See also GETNODALFUNCTIONS, GETNODALFUNCTIONSDERIVATIVESPARAMS

dh1dh2dh3_param=GetNodalFunctionsDerivativesParams(triaelem,gauss_l1l2l3); 
Jinv=GetJacobianInvert(triaelem,xyz_list, gauss_l1l2l3);
dh1dh2dh3_basic(1,1:3)=Jinv(1,1)*dh1dh2dh3_param(1,1:3)+Jinv(2,1)*dh1dh2dh3_param(2,1:3);
dh1dh2dh3_basic(2,1:3)=Jinv(1,2)*dh1dh2dh3_param(1,1:3)+Jinv(2,2)*dh1dh2dh3_param(2,1:3);
