/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA)

    CONTENTS:

        Definition of class FitnessRecord.

    NOTES:

        See notes under Class Definition section of this file.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        2.0.0

    CHANGES:

        Wed Dec 21 15:44:00 2005 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the definition of the FitnessRecord class.
 */




/*
================================================================================
Prevent Multiple Inclusions
================================================================================
*/
#ifndef JEGA_ALGORITHMS_FITNESSMAP_HPP
#define JEGA_ALGORITHMS_FITNESSMAP_HPP







/*
================================================================================
Includes
================================================================================
*/
// JEGAConfig.hpp should be the first include in all JEGA files.
#include <../Utilities/include/JEGAConfig.hpp>

#include <cstddef>






/*
================================================================================
Pre-Namespace Forward Declares
================================================================================
*/
namespace JEGA
{
    namespace Utilities
    {
        class Design;
    }
}






/*
================================================================================
Namespace Using Directives - DISCOURAGED!!
================================================================================
*/








/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace Algorithms {





/*
================================================================================
In-Namespace Forward Declares
================================================================================
*/
class FitnessRecord;







/*
================================================================================
In-Namespace File Scope Typedefs
================================================================================
*/








/*
================================================================================
Class Definition
================================================================================
*/
/**
 * \brief An interface for any data structure that can be used as a collection
 *        of fitness values for Designs.
 *
 * This is the data structure interface that is returned from fitness assessors
 * and passed into selectors, etc.
 *
 * This is an immutable interface meaning that there are no non-const methods.
 * Derived types should have a mutable interface.
 */
class FitnessRecord
{
    /*
    ===========================================================================
    Class Scope Typedefs
    ===========================================================================
    */
    public:


    protected:


    private:


    /*
    ===========================================================================
    Member Data Declarations
    ===========================================================================
    */
    private:





    /*
    ===========================================================================
    Mutators
    ===========================================================================
    */
    public:


    protected:


    private:


    /*
    ===========================================================================
    Accessors
    ===========================================================================
    */
    public:


    protected:


    private:


    /*
    ===========================================================================
    Public Methods
    ===========================================================================
    */
    public:




    /*
    ===========================================================================
    Subclass Visible Methods
    ===========================================================================
    */
    protected:





    /*
    ===========================================================================
    Subclass Overridable Methods
    ===========================================================================
    */
    public:

        /// Required override of this interface.
        /**
         * Implementations should return the fitness associated with
         * the supplied design or -DBL_MAX if an error occurs.
         *
         * \param des The Design to retrieve the fitness of.
         * \return The fitness recorded for des or -DBL_MAX if des is not
         *         found.
         */
        virtual
        double
        GetFitness(
            const JEGA::Utilities::Design& des
            ) const = 0;

        /// Required override of this interface.
        /**
         * Implementations should return the maximum fitness value in this
         * record or -DBL_MAX if there are none.
         *
         * \return The largest fitness value recorded in this record or
         *         -DBL_MAX if none.
         */
        virtual
        double
        GetMaxFitness(
            ) const = 0;

        /// Required override of this interface.
        /**
         * Implementations should return the minimum fitness value in this
         * record or DBL_MAX if there are none.
         *
         * \return The smallest fitness value recorded in this record or
         *         DBL_MAX if none.
         */
        virtual
        double
        GetMinFitness(
            ) const = 0;

        /// Required override of this interface.
        /**
         * Implementations should return the sum of fitness values in this
         * record or 0 if there are none.
         *
         * \return The sum of all fitness values recorded in this record or
         *         0 if none.
         */
        virtual
        double
        GetTotalFitness(
            ) const = 0;

        /// Required override of this interface.
        /**
         * Implementations should return the number of fitness entries in this
         * record.
         *
         * \return The number of fitness values recorded in this record.
         */
        virtual
        std::size_t
        GetSize(
            ) const = 0;

    protected:


    private:


    /*
    ===========================================================================
    Private Methods
    ===========================================================================
    */
    private:





    /*
    ===========================================================================
    Structors
    ===========================================================================
    */
    public:

        /// Default constructs a FitnessRecord object.
        FitnessRecord(
            ) {}

        /// Destructs a FitnessRecord object.
        virtual
        ~FitnessRecord(
            ) {}



}; // class FitnessRecord



/*
================================================================================
End Namespace
================================================================================
*/
    } // namespace Algorithms
} // namespace JEGA







/*
================================================================================
Include Inlined Functions File
================================================================================
*/
// Not using an Inlined Functions File.



/*
================================================================================
End of Multiple Inclusion Check
================================================================================
*/
#endif // JEGA_ALGORITHMS_FITNESSMAP_HPP
