function B=GetB_conduct(pentaelem,xyz_list,gauss_coord)
%GETB_CONDUCT - compute the B matrix for conduction in thermal model
%
%   Compute B  matrix. B=[B1 B2 B3 B4 B5 B6] where Bi is of size numgrids*NDOF
%   For grid i, Bi can be expressed in the basic coordinate system by:
%   Bi_basic=[dh/dx]
%            [dh/dy]
%            [dh/dz]
%   where h is the interpolation function for grid i.
%
%   Usage:
%      B=GetB_conduct(pentaelem,xyz_list,gauss_coord)
%
%   See also GETB_ADVEC, GETBPRIME_ADVEC, CREATEKMATRIX

num_grids=6;	

dh1dh6_basic=GetNodalFunctionsDerivativesBasic(pentaelem,xyz_list,gauss_coord);
%Build B:
B=zeros(3,num_grids);
for i=1:num_grids,
	B(1,i)=dh1dh6_basic(1,i);
	B(2,i)=dh1dh6_basic(2,i);
	B(3,i)=dh1dh6_basic(3,i);
end
