function [nu2,nu3]=visc_grad(index,nel,alpha,beta,u,v,B_bar)
%VISC_GRAD - computes the derivative of the viscosity with respect to the velocity
%
%   Usage:
%      [nu2,nu3]=visc_grad(index,nel,alpha,beta,u,v,B_bar)

nu2=zeros(nel,1);
nu3=zeros(nel,1);

[ux ,uy ,vx, vy]=shear(index,alpha,beta,u,v);

second_inv=(ux.^2 + vy.^2 + ((uy+vx).^2)/4 + ux.*vy);
location=find(second_inv~=0);
nu2(location)=B_bar(location).*(second_inv(location).^(-4/3))/2;
nu3(location)=second_inv(location).^(-1/3)/2;
location=find(second_inv==0);
nu2(location)=10^30; 
nu3(location)=10^30;
