function R_mg=MpcGrids(grids,constraints)
%MPCGRIDS - build the matrix R_mg
%
%   see NastranRgbDoc documentation in theoryguide directory
%
%   Usage:
%      R_mg=MpcGrids(grids,constraints)

%compute number of equations described by our rgbs
num_eq=0;
gsize=getdofcount(grids);

for i=1:length(constraints),
	if strcmpi(constraints(i).constraint.type,'rgb'),
		num_eq=num_eq+1;
	end
end

%allocate R_mg (num_eq,gsize)
R_mg=sparse(num_eq,gsize);

count=0;
for i=1:length(constraints),
	if strcmpi(constraints(i).constraint.type,'rgb'),
		%recover rgb constraint
		rgbconstraint=constraints(i).constraint;
		count=count+1;
		%figure out whith degrees of freedom this RGB is supposed to connect
		dof1=grids(rgbconstraint.grid1).grid.doflist(rgbconstraint.dof);
		dof2=grids(rgbconstraint.grid2).grid.doflist(rgbconstraint.dof);
		%plug rcb coefficients into R_mg
		R_mg(count,dof1)=1;
		R_mg(count,dof2)=-1; %basically, we want dof1 and dof2 to be equal, for grids 1 and 2
	end
end
