%
%  definition for the continuous_state class.
%
%  [csv]=continuous_state(varargin)
%
classdef continuous_state
    properties
        descriptor='';
        initst    = NaN;
        lower     = NaN;
        upper     = NaN;
    end
    
    methods
        function [csv]=continuous_state(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object

                case 1
                    if isa(varargin{1},'continuous_state')
                        csv=varargin{1};
                    else
                        error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
                            inputname(1),class(varargin{1}),'continuous_state');
                    end

%  create the object from the input

                otherwise
                    csv.descriptor=varargin{1};
                    csv.initst    =varargin{2};
                    if (nargin >= 3)
                        csv.lower     =varargin{3};
                        if (nargin >= 4)
                            csv.upper     =varargin{4};
                            if (nargin > 4)
                                warning('continuous_state:extra_arg',...
                                    'Extra arguments for object of class ''%s''.',...
                                    class(csv));
                            end
                        end
                    end
            end

        end
        function [desc]  =dvar_desc(csv)
            desc=cell(size(csv));
            for i=1:numel(csv)
                desc(i)=cellstr(csv(i).descriptor);
            end
            desc=allempty(desc);
        end
        function [initpt]=dvar_initpt(csv)
            initpt=[];
        end
        function [lower] =dvar_lower(csv)
            lower=zeros(size(csv));
            for i=1:numel(csv)
                lower(i)=csv(i).lower;
            end
            lower=allnan(lower);
        end
        function [upper] =dvar_upper(csv)
            upper=zeros(size(csv));
            for i=1:numel(csv)
                upper(i)=csv(i).upper;
            end
            upper=allnan(upper);
        end
        function [mean]  =dvar_mean(csv)
            mean=[];
        end
        function [stddev]=dvar_stddev(csv)
            stddev=[];
        end
        function [initst]=dvar_initst(csv)
            initst=zeros(size(csv));
            for i=1:numel(csv)
                initst(i)=csv(i).initst;
            end
        end
    end
end
