%
%  display for the continuous_design class.
%
%  []=display(cdv)
%
function []=display(cdv)

if ~isa(cdv,'continuous_design')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(cdv),'continuous_design');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(cdv)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(cdv),inputname(1),string_dim(cdv,i)));
    disp(sprintf('    descriptor: ''%s'''  ,cdv(i).descriptor));
    disp(sprintf('        initpt: %g'      ,cdv(i).initpt));
    disp(sprintf('         lower: %g'      ,cdv(i).lower));
    disp(sprintf('         upper: %g\n'    ,cdv(i).upper));
end

end
