function a = set(a,varargin)
%SET - set model properties and return the updated object
% 
%   Usage:
%      a = set(a,varargin)

propertyArgIn = varargin;
while length(propertyArgIn) >= 2,
	prop = propertyArgIn{1};
	val = propertyArgIn{2};
	propertyArgIn = propertyArgIn(3:end);
	switch prop
	case 'numberofelements'
		a.numberofelements = val;
	case 'numberofgrids'
		a.numberofgrids = val;
	case 'elements'
		a.elements = val;
	case 'x'
		a.x = val;
	case 'y'
		a.y = val;
	case 'z'
		a.z = val;
	otherwise
		error(['set error message: ' prop,' is not a valid model property'])
	end
end
