/*!\file:  Element.h
 * \brief abstract class for Element object
 * This class is a place holder for the Tria and the Penta elements. 
 * It is derived from Element, so DataSets can contain them.
 */ 


#ifndef _ELEMENT_H_
#define _ELEMENT_H_

#include "./Object.h"
#include "./ParameterInputs.h"
#include "../toolkits/toolkits.h"
#include "./Node.h"
#include "./Matpar.h"

class Element: public Object{

	public: 
		virtual       ~Element(){};
		virtual void  Echo()=0;
		virtual int   GetId()=0;
		virtual int   MyRank()=0;
		virtual void  Marshall(char** pmarshalled_dataset)=0;
		virtual int   MarshallSize()=0;
		virtual char* GetName()=0;
		virtual void  Demarshall(char** pmarshalled_dataset)=0;
		virtual void  Configure(void* loads,void* nodes,void* materials)=0;
		virtual void  CreateKMatrix(Mat Kgg,ParameterInputs* inputs,int analysis_type)=0;
		virtual void  CreatePVector(Vec pg, ParameterInputs* inputs, int analysis_type)=0;
		virtual void  UpdateFromInputs(ParameterInputs* inputs)=0;
		virtual void  GetNodes(Node** nodes)=0;
		virtual Matpar* GetMatPar()=0;
		virtual int   GetShelf()=0; 
		virtual int   GetOnBed()=0;
		virtual void          GetThicknessList(double* thickness_list)=0;
		virtual void          GetBedList(double* bed_list)=0;
		virtual void  Du(Vec du_g,double* u_g,double* u_g_obs,ParameterInputs* inputs,int analysis_type)=0;
		virtual void  Gradj(Vec grad_g,double* u_g,double* lambda_g,ParameterInputs* inputs,int analysis_type,char* control_type)=0;
		virtual void  GradjDrag(Vec grad_g,double* u_g,double* lambda_g,ParameterInputs* inputs,int analysis_type)=0;
		virtual void  GradjB(Vec grad_g,double* u_g,double* lambda_g,ParameterInputs* inputs,int analysis_type)=0;
        virtual double Misfit(double* u_g,double* u_g_obs,ParameterInputs* inputs,int analysis_type)=0;

		int           Enum();
		
};
#endif
