function res=xyscale_south(lat);
%XYSCALE_SOUTH - calculate scaling factor
%
%   latitude is <0 in degrees.
%
%   Usage:
%      res=xyscale_south(latatitude)
lat=-lat/180*pi;

m71_t71=1.9390295644;
e2=.00669437999015;
e=sqrt(e2);

m=cos(lat)./sqrt(1-e2*sin(lat).^2);
t=tan(pi/4-lat/2)./((1-e*sin(lat))./(1+e*sin(lat))).^(e/2);
k=m71_t71*t./m;
res=(1./k./k);
