#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=`grep -c processor /proc/cpuinfo`;

#version of slepc
version=`echo *.tgz | sed 's/\.tgz//g' | sed 's/slepc-//g'`

#Some cleanup
rm -rf install slepc-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  slepc-$version.tgz

#Move slepc to install directory
mv slepc-$version/* install/
rm -rf slepc-$version

#Make slepc
cd install
./config/configure.py
make  -j $NUMCPUS
