/* This is third-party software that is distributed with Acro.
 * For licensing information concerning this file, see the Acro home page:
 * http://software.sandia.gov/Acro
 */

///////////////////////////////////////////////////////////////////
/*****************************************************************
Copyright: Artificial Life and Adaptive Robotics Laboratory - ALAR
School of ITEE, UNSW@ADFA, Australia, 2005
*******************************************************************/
///////////////////////////////////////////////////////////////////

//#include "stdafx.h"
#include "objective.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

objective::objective()
 {
 	objective_func= &problem1; //default;	
 }
objective::objective(int ID)
{
	setObjID(ID);
		
}
objective::~objective()
{
	
}

//DEL double objective::f1(double *x, int size) 
//DEL {
//DEL 	//return 1.1f-x[0];
//DEL 	return x[0];
//DEL }

//DEL double objective::f2(double *x, int size) 
//DEL {
//DEL 	//return 60.0f-(1+x[1])/x[0];
//DEL 	
//DEL 	int i;
//DEL 	double g=0.0;
//DEL 	for (i=1;i<size;i++)
//DEL 		g+=x[i];
//DEL 	g=1.0+9.0*g/(size-1);
//DEL 	return g*(1-sqrt(f1(x,size)/g));
//DEL 	
//DEL }
/* ------------------Usage---------------------------------
objective obj; //general objective;
cout << obj.objective_func1(0.7,0.2,&objective::f1);

  double objective::objective_func1(double x1, double x2,double (objective::*fp)(double,double))
	{
	return (this->*fp)(x1,x2);
	}
---------------------end---------------------------------------*/
void objective::setObjID(int ID)
{
	switch(ID)
	{
	case 1:
		objective_func= &problem1;
		break;
	case 2:
		objective_func= &problem2;
		break;
	case 3:
		objective_func= &problem3;
		break;
	case 4:
		objective_func= &problem4;
		break;
	case 6:
		objective_func= &problem6;
		break;
	}
}

void objective::setObjfunc(double (*f)(double*, int, int)) {
	objective::objective_func = f;
}

// cut from operators_NSGA2.cpp
//          for(int j=0;j<n_Objs;j++)   // calculate fitness value without noise
//          {
//                  if (objID==5)
//                          fitness[j]=problem5(id.Bgenes,id.chromosome_len,j);
//                  else
//                          fitness[j]=(*obj.objective_value)(real_params,n_Genes,j);
//          }

void objective::evaluate(double *genes, int n_Genes, double *fitness, int n_Objs) {
    // calculate fitness value without noise
    for(int i= 0; i < n_Objs; i++) {
	fitness[i]=(*(this->objective_func))(genes, n_Genes, i);
    }
}


// void objective::evaluate(vector<double> genes, vector<double> fitness) {
//     for(int i= 0; i < n_Objs; i++) {
// 	fitness[i]=(*(this->objective_func))(genes, n_Genes, i);
//     }
// }

double problem1(double *x, int size,int funcID)
{
	if (funcID==0) 
		return x[0];
	else
	{
		int i;
		double g=0.0;
		double F1=x[0];
		for (i=1;i<size;i++)
			g+=x[i];
		g=1.0+9.0*g/(size-1);
		return g*(1-sqrt(F1/g));
	}
}
double problem2(double *x, int size,int funcID)
{
	if (funcID==0) 
		return x[0];
	else
	{
		int i;
		double g=0.0;
		double F1=x[0];
		for (i=1;i<size;i++)
			g+=x[i];
		g=1.0+9.0*g/(size-1);
		return g*(1-pow(F1/g,2));
	}
}
double problem3(double *x, int size,int funcID)
{
	if (funcID==0) 
		return x[0];
	else
	{
		int i;
		double g=0.0;
		double F1=x[0];
		for (i=1;i<size;i++)
			g+=x[i];
		g=1.0+9.0*g/(size-1);
		return g*(1-pow(F1/g,2)-(F1/g)*sin(10*PI*F1));
	}
}
double problem4(double *x, int size,int funcID)
{
	double g=0,F1=x[0];
	int i;
	if (funcID==0)
		return F1;
	else
	{
	for (i=1;i<size;i++)
			g+=x[i]*x[i]-10*cos(4*PI*x[i]);
	g=1+10*(size-1)+g;
	return g*(1-sqrt(F1/g));
	}
}
double problem5(unsigned int *x, int size,int funcID)
{
	
	double g=0,F1=0;
	int i,j,temp=0;
	for (i=0;i<30;i++)
	{
		
		if (x[i]==1) F1+=1;
	}

    F1=1+F1;
	if (funcID==0)
		return F1;
	else
	{
	
		for (i=1;i<11;i++)
		{
			temp=0;
			for (j=0;j<5;j++)
				if (x[30+5*(i-1)+j]==1)  temp++;
			if (temp<5) 
				g+=2+temp;
			else
				g+=1;
		
		}
		return g*(1/F1);
	}
}
double problem6(double *x, int size,int funcID)
{

double g=0,F1=1-exp(-4*x[0])*pow(sin(6*PI*x[0]),6);
int i;
	if (funcID==0)
		return F1;
	else
	{
	for (i=1;i<size;i++)
			g+=x[i];
	g=1+9*pow((g/(size-1)),0.25);
	return g*(1-pow(F1/g,2));
	}	
}
