function [segment_coord,gauss_weights]=GaussSegment(numgauss)
%GAUSSSEGMENT - get Gauss point for segment elements
%
%   This routine computes numgauss gaussian points on a reference segment from -1 to 1.
%   The number of gaussian points returned depends on the order of integration ('order'). The order of 
%   integration can be computed from the polynomial degree p that needs to be integrated. The formula is: 
%   order = (p+1) /2 
%   order=1, num_gauss=1. Can integrate polynomials of degree 0 to 1
%
%   Usage:
%      [segment_coord,gauss_weights]=GaussSegment(numgauss)

if numgauss==1,

	segment_coord=0;
	gauss_weights=2;

%p=3, numgauss=2. Can integrate polynomials of degree 0 to 3
elseif numgauss==2,
	gauss_weights=[ 1.0, 1.0];
	segment_coord=[-0.577350269189626, 0.577350269189626];

%p=5, numgauss=3. Can integrate polynomials of degree 0 to 5
elseif numgauss==3,
	gauss_weights=[ 0.555555555555555556, 0.88888888888889, 0.555555555555555556];
	segment_coord=[ -0.774596669241483, 0.000000000000000, 0.774596669241483];

%p=7, numgauss=4. Can integrate polynomials of degree 0 to 7
elseif numgauss==4,
	gauss_weights=[ 0.347854845137454, 0.652145154862546, 0.652145154862546, 0.347854845137454];
	segment_coord=[ -0.861136311594053, -0.339981043584856, 0.339981043584856, 0.861136311594053];

%p=9, numgauss=5. Can integrate polynomials of degree 0 to 9
elseif numgauss==5,
	gauss_weights=[ 0.236926885056189, 0.478628670499366, 0.568888888888889, 0.478628670499366, 0.236926885056189];
	segment_coord=[ -0.906179845938664, -0.538469310105683, 0, 0.538469310105683, 0.906179845938664];


else
	error('GaussSegment error message: order not supported yet');
end
