/*\file Dof.c
 *\brief: build degrees of freedom for every grid.
 */

#include "./Dof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* nodes=NULL;
	DataSet* elements=NULL;
	DataSet* params=NULL;

	/* output datasets: */
	Vec partition=NULL;
	Vec tpartition=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&DofUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODESIN,"DataSet",NULL);
	FetchData((void**)&params,NULL,NULL,PARAMS,"DataSet",NULL);

	/*!Generate internal degree of freedom numbers: */
	Dofx(&partition, &tpartition,elements,nodes,params); 

	/*partition and tpartition should be incremented by 1: */
	VecShift(partition,1.0); //matlab indexing starts at 1.
	VecShift(tpartition,1.0);

	/*write output datasets: */
	WriteData(NODES,nodes,0,0,"DataSet",NULL);
	WriteData(PARTITION,partition,0,0,"Vector",NULL);
	WriteData(TPARTITION,tpartition,0,0,"Vector",NULL);

	/*Free ressources: */
	delete nodes;
	delete elements;
	delete params;
	VecFree(&partition);
	VecFree(&tpartition);

	/*end module: */
	MODULEEND();
}

void DofUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [nodes,part,tpart] = %s(elements, nodes,params);\n",__FUNCT__);
	_printf_("\n");
}
