import sys
sys.path = sys.path + [ '../src' ]
import exact

###
### Testing stuff
###
### Ignore IOError exceptions, but other exceptions cause fatal faults
###

try:
  #
  # Load the UTILIB experimental results and print out the information
  #
  study = exact.ExperimentalStudy("../../utilib/test/utilib.exp.xml")
  study.pprint()
  #
  # Perform an analysis on utilib
  #
  analysis = exact.ValidationAnalysis()
  analysis.measurement = "diffs"
  analysis.value = 0
  if study.experiments["exp1"].results:
     analysis.analyze(study.experiments["exp1"].results)
     print ""
except IOError:
  pass

try:
  #
  # Load the PICO performance comparison results
  #
  study = exact.ExperimentalStudy("../../pico/test/milp-comparison.exp.xml")
  study.pprint()
  #
  # Perform a performance analysis of PICO
  #
  analysis = exact.RelativePerformanceAnalysis()
  analysis.target_factor="solver"
  analysis.target_level="pico-nocuts"
  analysis.measurement="Seconds"
  if study.experiments["exp1"].results:
     analysis.analyze(study.experiments["exp1"].results)
except IOError, detail:
  print detail
  pass


try:
  #
  # Load the build and config information
  #
  configinfo = exact.SoftwareInfo("../../../../test/20061011#001504#wehart#tofu.sandia.gov#acro-gnlp-npsol-n#scenario.xml")
  configinfo.pprint()
  configinfo = exact.SoftwareInfo("../../../test/config.xml")
  configinfo.pprint()
  buildinfo = exact.SoftwareInfo("../../../test/build.xml")
  buildinfo.pprint()
except IOError, detail:
  print detail
  pass

try:
  #
  # Load a study
  #
  scenario = exact.Scenario("../../../../test/20061011#001504#wehart#tofu.sandia.gov#acro-gnlp-npsol-n#scenario.xml")
  scenario.pprint()
except IOError, detail:
  print detail
  pass

