/*
 * ProcessBatchParameters.c:
 *	   from ncase dataset, fill in the BatchParams* structure, so that the solution sequences (in batch/, for ex. cielodiagnostic.c) can get access to 
 *	   solution parameters (like eps, tolx, etc ...)
 */
#include "../include/cielo.h" 
#include "./Model.h"

#ifdef _PARALLEL_

int ProcessBatchParameters(BatchParams* params,Model* model,DataSet* ncase){

	int noerr=1;
	int i;

	/* general dataset handling: */
	Param* param=NULL;

	/*Firt recover analysis_type: */
	params->analysis_type=xmalloc(strlen(model->analysis_type)*sizeof(char));
	strcpy(params->analysis_type,model->analysis_type);
	params->analysis_type_enum=GetAnalysisTypeAsEnumFromString(params->analysis_type);

	/*Go through ncase, looking for parameters: */
	for ( i=0; i<DataSetAllObjectCount(ncase); i++) {
		if ( ParamEnum()==DataSetGetEnum(ncase,i)){

			param=DataSetGetObjectPtr(ncase,i);

			if (strcasecmp_eq(ParamGetTypeString(param),"sparsity")){
				params->sparsity=ParamGetRealValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"solverstring")){
				params->solverstring=xmalloc((strlen(ParamGetStringValue(param))+1)*sizeof(char));
				strcpy(params->solverstring,ParamGetStringValue(param));
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"connecti")){
				params->connectivity=ParamGetIntegerValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"eps_rel")){
				params->eps_rel=ParamGetRealValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"debug")){
				params->debug=ParamGetIntegerValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"debug")){
				params->debug=ParamGetIntegerValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"beta")){
				params->beta=ParamGetRealValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"meltingpoint")){
				params->meltingpoint=ParamGetRealValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"latentheat")){
				params->latentheat=ParamGetRealValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"heatcapacity")){
				params->heatcapacity=ParamGetRealValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"penalty_thermal")){
				params->penalty_thermal=ParamGetRealValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"min_thermal_constraints")){
				params->min_thermal_constraints=ParamGetIntegerValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"waitonlock")){
				params->waitonlock=ParamGetIntegerValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"dt")){
				params->dt=ParamGetRealValue(param);
			}
			if (strcasecmp_eq(ParamGetTypeString(param),"ndt")){
				params->ndt=ParamGetRealValue(param);
			}
		}
	}
	return noerr;

}
#endif
