#!/bin/csh -f

########################################################################
# This is the environment setting script for Dakota's CSH-based test
# suite.  It sets up the environment for internal Sandia systems in, 
#        SCICO Lan
#        Capacity clusters
#
# It is sourced by '[run,send]_[base|package]_[test,mail].csh'.
#
# Assumptions:
# - if environment variable DAKOTA_ROOT has already been set, this script
#   will not change it; otherwise, it will be set to the default Dakota 
#   installation directories on Sandia systems
# - if environment variable SNLSYSTEM does not already exist, it will be
#   set to 'scico'.  If this script will be used on systems other than
#   those listed above, it might be necessary to modify this logic.
# - if environment variables TEST_DIR and TEST_SQA are not set before this
#   script is sourced, they will be set here.
#
# Environment variables set in this script:
#   ARCH           = result of `uname -m`
#   UNAME          = result of `uname`
#   PROCTYPE       = result of `uname -p`
#   SNLSYSTEM      = if not set (e.g. icc/nwcc/thunderbird/redstorm), will
#                    be set to 'scico'
#   TEST_DIR       = if not set before sourcing this script, will be set to
#                    ${SNLSYSTEM}_${UNAME}_${PROCTYPE}
#   TEST_PLATFORM  = based on `uname`
#   TEST_PLATFORM_VER = OS and processor specification
#   DAKOTA_ROOT    = if not set before sourcing this script, will be set to
#                    the usual Dakota locations on scico or clusters
#   TEST_SQA       = if not set before sourcing this script, will be set to
#                    $DAKOTA_ROOT/Dakota/test/sqa
#   CVS_RSH        = "ssh"
#   DEV_SVNROOT    = subversion repository on //development.sandia.gov
#   SOF_SVNROOT    = subversion repository on //software.sandia.gov
#   USE_QSUB       = set to 'yes' for clusters requiring qsub submissions   
#   USE_SLURM      = set to 'yes' for clusters requiring slurm submissions
# 
#   Compilation and linking environments are set (e.g. compilers names and
#   flags, MPI locations, nonstandard BLAS/LAPACK libraries, optimization
#   flags)
#
#   PATH and MANPATH are also set to include required libraries and documents
#
#
########################################################################

# Default user .cshrc file (/bin/csh initialization).
# Set up C shell environment: source system-wide .cshrc
if ( -r /usr/local/etc/system.cshrc ) then
  source /usr/local/etc/system.cshrc
endif

setenv ARCH `uname -m`
setenv UNAME `uname`
setenv PROCTYPE `uname -p`

# Figure out what system/cluster we are running on...
if ( $UNAME == 'Darwin' ) then
  #Run on build/test machine in csri, dakmacppc
  setenv SNLSYSTEM csri
else if ( ${?SNLSYSTEM} == 0 ) then
  #Default to SCICO LAN
  setenv SNLSYSTEM scico
endif
if ( ${?TEST_DIR} == 0 ) then
  setenv TEST_DIR ${SNLSYSTEM}_${UNAME}_${PROCTYPE}
endif
##echo "TEST_DIR is $TEST_DIR "

# Need /usr/local/bin to be ahead of /usr/bin in the $PATH on some systems
# (removing duplicates could be better...quick and dirty for now)
setenv PATH `echo $PATH | sed 's/\/usr\/local\/bin/\/usr\/bin/'`
setenv PATH `echo $PATH | sed 's/\/usr\/bin/\/usr\/local\/bin/'`

# --- Initial settings for everybody ---
setenv CVS_RSH "ssh"
setenv DEV_SVNROOT "svn+ssh://development.sandia.gov/usr/local/svn"
setenv SOF_SVNROOT "svn+ssh://software.sandia.gov/svn/private"
# Set umask to allow group write permission on all created files
umask 002
# Default optimization flags for most systems (will be reset if req'd)
setenv CFLAGS "-O2"
setenv CXXFLAGS "-O2"
setenv FFLAGS "-O2"
setenv FCFLAGS "-O2"
setenv TEST_PARALLEL no
setenv BUILD_JOBS "1"
setenv USE_QSUB no
setenv USE_SLURM no
 
if ( $SNLSYSTEM == 'scico' ) then
  # Miscellaneous netpub tools setup
  setenv PATH "/usr/netpub/bin:"$PATH
  # Autotools, Dakota, Subversion and test directory setup
  setenv AUTOHOME "/usr/netpub/autotools"
  setenv SVNHOME "/usr/netpub/subversion"

  if ( $UNAME == 'AIX' ) then
    stty sane dec
    # Paths...
    setenv MANPATH "/usr/lpp/xlf/man/en_US:"$MANPATH
    setenv MANPATH "/usr/vac/man/en_US:/usr/vacpp/man/en_US:"$MANPATH
    # need to pickup GNU tar first
    setenv PATH /opt/freeware/bin:$PATH
    # Environment...
    setenv TEST_PLATFORM     aix
    setenv TEST_PLATFORM_VER aix5.3
    setenv TEST_PARALLEL     yes
    setenv BUILD_JOBS "16"
    setenv CC "xlc"
    setenv CXX "xlC"
    setenv F77 "xlf"
    setenv FC "xlf90"
    setenv LAPACK_LIBS "/usr/local/lib/lapack_AIX.a -lessl"
    # this is not a complete BLAS, may need to change to -lblas for 
    # sub-optimal, but complete BLAS
    setenv BLAS_LIBS "-lessl"
    setenv DAKOTA_CONFIG_OPT "--without-graphics"
    setenv CXXFLAGS "-O2 -DTEUCHOS_PRIVIATE_DELETE_NOT_SUPPORTED"

    if ( ${?DAKOTA_ROOT} == 0 ) then
      setenv DAKOTA_ROOT "/projects/dakota"
    endif

  else if ( $UNAME == 'Darwin' ) then
    # NOTE (kh20080908):  Not currently using a Mac on SCICO; leave this 
    #        section for possible future use.
    # Updated for 10.4.x Tiger and gcc 4.1 or better; macports paths
    # Paths...
    setenv PATH "/opt/local/bin:/usr/bin:"$PATH
    #Command not found. setenv MANPATH `manpath`
    #MANPATH not set# setenv MANPATH $MANPATH":/opt/local/man"
    setenv MANPATH "/opt/local/man"
    # MPI includes and libs are in /opt/local

#   old environment below
#    setenv MPIHOME "/usr/local/mpich-1.2.7p1_ssh"
#    setenv PATH $PATH":/opt/ibmcmp/xlf/8.1/bin"
#    setenv PATH $PATH":/sw/bin:/sw/sbin"
#    setenv MANPATH "$MPIHOME/man:"$MANPATH
#    setenv PATH "$MPIHOME/sbin:"$PATH
#    setenv PATH "$MPIHOME/bin:"$PATH
#    setenv PATH $PATH":/usr/bin"

    # Environment...
    setenv TEST_PLATFORM     darwin
    setenv TEST_PLATFORM_VER darwin8.11.0
    setenv BUILD_JOBS "1"
    setenv CC  "gcc-mp-4.3"
    setenv CXX "g++-mp-4.3"
    setenv F77 "gfortran-mp-4.3"
    setenv FC  "gfortran-mp-4.3"
    setenv CXXFLAGS "-DMPICH_IGNORE_CXX_SEEK"
    setenv LDFLAGS "-framework Accelerate"
    setenv MPICXX "openmpicxx"
    setenv X_CFLAGS "-I/opt/local/include/X11"
    setenv X_LIBS "-L/opt/local/lib"
    #setenv DAKOTA_CONFIG_OPT "--with-blas="-framework Accelerate""
#                 setenv LDFLAGS "-Wl,-framework -Wl,vecLib" 
#old fink setup#  setenv DAKOTA_MAKE_OPT "AM_LDFLAGS="-all-static""

   # Set environment variable to handle Kerberos tickets 
   # for the cron environment
   setenv KRB5CCNAME "FILE:/Users/dakota/krb5cache"

    if ( ${?DAKOTA_ROOT} == 0 ) then
      setenv DAKOTA_ROOT "/projects/dakota"
    endif


  else if ( $UNAME == 'IRIX64' ) then
    # Currently not in use for nightly build/test
    stty sane dec
    # Paths...
    # Environment...
    setenv TEST_PLATFORM     irix
    setenv TEST_PLATFORM_VER irix6.5
    setenv AWK "/bin/awk"
    setenv BUILD_JOBS "4"
    setenv CC "cc"
    setenv CXX "CC"
    setenv F77 "f77"
    setenv FC "f90"
    setenv EDG_PRELINK_INPUT_LINE_SIZE 65536
    setenv SGI_ABI "-64"
    setenv X_CFLAGS "-I/usr/include"
    setenv X_LIBS "-L/usr/lib64"
    setenv YACC "/usr/bin/yacc"

  else if ( $UNAME == 'Linux' ) then
    # Environment...(some have override below)
    setenv TEST_PARALLEL yes
    setenv BUILD_JOBS "4"
    setenv CC "gcc"
    setenv CXX "g++"
    setenv F77 "g77"
    setenv FC "gfortran"
    setenv LDFLAGS "-static-libgcc"
    setenv DAKOTA_MAKE_OPT "AM_LDFLAGS="-all-static""
    # Paths...
    setenv MANPATH `manpath`
    if ( $ARCH == 'i686' ) then
      setenv TEST_PLATFORM     linux32
      setenv AUTOHOME `echo "$AUTOHOME"32`
      setenv SVNHOME `echo "$SVNHOME"32`
      # the logic here needs improvement to properly detect distribution
      if ( -d /usr/local/mpi/mpich/32Bit/1.2.7/gcc-3.4.3 ) then # RHEL 4
	#setenv MPIHOME "/usr/netpub/mpi/mpich/32bit/1.2.7p1/gcc-4.1.1"
	setenv MPIHOME "/home/dakota/mpich-1.2.7p1_noromio_i686"
	setenv TEST_PLATFORM_VER rhel4_i686
	setenv CC "gcc4"
	setenv CXX "g++4"
	setenv F77 "g77"
	setenv FFLAGS "-O2 -fno-f2c"
	setenv BLAS_LIBS "-L/home/dakota/atlas-3.8.0-rhel4_i686_gcc-4.1.1/lib -lf77blas -latlas"
	setenv LAPACK_LIBS "-L/home/dakota/atlas-3.8.0-rhel4_i686_gcc-4.1.1/lib -llapack -lf77blas -lcblas -latlas"
	setenv DAKOTA_CONFIG_OPT "--with-teuchos=/home/dakota/build/teuchos_Linux_i686 --without-graphics"
	# need to determine if / how to pass these in DAKOTA_CONFIG_OPT -- hard due to spaces/need for quotes
      else if ( -d /usr/local/mpi/mpich/1.2.5.2/gcc-3.2.2 ) then # RedHat 9
	setenv FC "pgf90"
        setenv MPIHOME "/usr/local/mpi/mpich/1.2.5.2/gcc-3.2.2"
        setenv TEST_PLATFORM_VER rh9_i686
	set pgifix32 = 'sed -e s/_5\.0//g -e s/5\.0/6\.0/g'
	setenv PGI `echo $PGI | $pgifix32`
	setenv PATH `echo $PATH | $pgifix32`
	setenv LD_LIBRARY_PATH `echo $LD_LIBRARY_PATH | $pgifix32`
	setenv MANPATH `echo $MANPATH | $pgifix32`
	setenv LM_LICENSE_FILE 7496@sass4000:7496@sass4002:7496@sass4004
      endif
    else  if ( $ARCH == 'x86_64' ) then
      setenv TEST_PLATFORM     linux64
      if ( -d /usr/local/mpi/mpich/64Bit/1.2.7/gcc-3.4.3 ) then # RHEL 4
        setenv MPIHOME "/usr/local/mpi/mpich/64Bit/1.2.7/gcc-3.4.3"
        setenv TEST_PLATFORM_VER rhel4_x86_64
	setenv MPICXX mpiCC
      endif
    endif
    setenv MANPATH "$MPIHOME/man:"$MANPATH
    setenv PATH "$MPIHOME/sbin:"$PATH
    setenv PATH "$MPIHOME/bin:"$PATH

  else if ( $UNAME == 'SunOS' ) then
    #setenv DAKOTA_CONFIG_OPT "--without-acro"
    # Paths...
    setenv MPIHOME "/opt/SUNWhpc"
    setenv MANPATH "$MPIHOME/man:"$MANPATH
    setenv PATH "$MPIHOME/sbin:"$PATH
    setenv PATH "$MPIHOME/bin:"$PATH
    # Environment...
    setenv TEST_PLATFORM     solaris
    setenv TEST_PLATFORM_VER solaris2.10
    setenv TEST_PARALLEL yes
    setenv BUILD_JOBS "4"
    setenv CC "cc"
    setenv CXX "CC"
    setenv F77 "f77"
    setenv FC "f90"
    setenv LDFLAGS "-lmvec"
    setenv YACC "/usr/ccs/bin/yacc"
    setenv CFLAGS "-fast"
    # Additional flags are needed on Solaris due to Boost's templatized headers
    setenv CXXFLAGS "-fast -library=stlport4,sunperf -features=tmplife -features=tmplrefstatic"
    setenv FFLAGS "-fast"
    setenv FCFLAGS "-fast"
  endif

  if ( ${?DAKOTA_ROOT} == 0 ) then
    setenv DAKOTA_ROOT "/usr/sharelan/dakota"
  endif

else if ( $SNLSYSTEM == 'csri' && $UNAME == 'Darwin' ) then
  # Updated for 10.4.x Tiger and gcc 4.1 or better; macports paths
  # Paths...
  setenv AUTOHOME "/usr/bin" 
  setenv SVNHOME "/opt/local/bin" 
  setenv PATH "/opt/local/bin:/usr/bin:"$PATH
  #Command not found. setenv MANPATH `manpath`
  #MANPATH not set# setenv MANPATH $MANPATH":/opt/local/man"
  setenv MANPATH "/opt/local/man"
  # MPI includes and libs are in /opt/local
 
  #old environment below
  # setenv MPIHOME "/usr/local/mpich-1.2.7p1_ssh"
  # setenv PATH $PATH":/opt/ibmcmp/xlf/8.1/bin"
  # setenv PATH $PATH":/sw/bin:/sw/sbin"
  # setenv MANPATH "$MPIHOME/man:"$MANPATH
  # setenv PATH "$MPIHOME/sbin:"$PATH
  # setenv PATH "$MPIHOME/bin:"$PATH
  # setenv PATH $PATH":/usr/bin"
 
  # Environment...
  setenv TEST_PLATFORM     darwin
  setenv TEST_PLATFORM_VER darwin8.11.0
  setenv BUILD_JOBS "1"
  setenv CC  "gcc-mp-4.3"
  setenv CXX "g++-mp-4.3"
  setenv F77 "gfortran-mp-4.3"
  setenv FC  "gfortran-mp-4.3"
  setenv CXXFLAGS "-DMPICH_IGNORE_CXX_SEEK"
  setenv LDFLAGS "-framework Accelerate"
  setenv MPICXX "openmpicxx"
  setenv X_CFLAGS "-I/opt/local/include/X11"
  setenv X_LIBS "-L/opt/local/lib"
  #setenv DAKOTA_CONFIG_OPT "--with-blas="-framework Accelerate""
  #                 setenv LDFLAGS "-Wl,-framework -Wl,vecLib" 
  #old fink setup#  setenv DAKOTA_MAKE_OPT "AM_LDFLAGS="-all-static""
 
  if ( ${?DAKOTA_ROOT} == 0 ) then
    setenv DAKOTA_ROOT "/projects/dakota"
  endif

else 
  # TLCC/ICC/NWCC/Thunderbird and Redstorm
  if ( ${?DAKOTA_ROOT} == 0 ) then
    setenv DAKOTA_ROOT "/projects/dakota"
  endif
  setenv MANPATH `manpath`
  setenv AUTOHOME "/usr/bin"
  setenv SVNHOME "/usr/bin"
  setenv TEST_PARALLEL yes  #either qsub or slurm submissions
  setenv DAKOTA_CONFIG_OPT "--without-graphics"

  if ( $SNLSYSTEM == 'tlcc' ) then
    setenv USE_SLURM yes
    #Paths...
    # Assume default  environment includes MPIHOME in MANPATH
    # Environment...
    setenv TEST_PLATFORM     linux64
    setenv TEST_PLATFORM_VER rhel5_x86_64
    # Use the PGI environment or the Intel environment; choose
    # which one by checking some environment variables.
    if  ( ${?INTEL_LICENSE_FILE} != 0 ) then
      # Intel environment
      echo "TLCC WARNING:  Insure that Intel compilers and MKL modules are loaded."
      setenv CC icc
      setenv CXX icpc
      setenv F77 ifort
      setenv FC ifort
      setenv BLAS_LIBS "-L$MKL_LIB -lmkl_em64t"
      setenv LAPACK_LIBS "-L$MKL_LIB -lmkl_lapack"
      setenv LDFLAGS "-pthread -L$MKL_LIB -lguide"
    else if ( ${?PGI} != 0   ) then
      # PGI environment
      echo "TLCC:  using PGI environment." 
      setenv CC pgcc
      setenv CXX pgCC
      setenv F77 pgf77
      setenv FC pgf90
      # Check whether ACML library module is loaded and modify settings.
      if ( ${?BLASLIB} != 0 ) then
        echo "TLCC:  ACML library module is loaded."
        # Currently the BLASLIB environment variable includes compiler
        # directives that cause failures in packages, 
        # "error: support for exception handling is disabled"
        # There redefine BLASLIB to omit "-mp=align,numa" but leave
        # the rest.
        setenv BLASLIB "$ACML_LIB/libacml_mp.a -pgf77libs -Mcache_align"
        setenv CFLAGS "$CFLAGS -pgf77libs -Mcache_align"
        setenv CXXFLAGS "$CXXFLAGS -pgf77libs -Mcache_align"
        setenv FFLAGS "$FFLAGS -pgf77libs -Mcache_align"
        setenv FCFLAGS "$FFLAGS -pgf77libs -Mcache_align"
        setenv LDFLAGS "$BLASLIB"
        # The environment variable BLASLIB is set by the ACML module with
        # appropriate compiler/linker flags (and turns on OpenMP)
        setenv BLAS_LIBS "-L${ACML_LIB} -lacml_mp" 
        # LAPACK is in the same library as BLAS#  setenv LAPACK_LIBS "$BLASLIB"
        # NOTE (kh): 20081013 ACML BLAS library lacks entry points crot/zrot
        # required by DAKOTA.  Either use another BLAS library or modify
        # configure to select crot_/zrot_ entry points.
      endif
    else
      echo "Unable to select either PGI or Intel environment; verify that appropriate modules are loaded."
    endif
    setenv DAKOTA_CONFIG_OPT "--without-graphics"

  else if ( $SNLSYSTEM == 'icc' ) then
    setenv USE_QSUB yes
    # Paths...
    # Assume default environment includes MPIHOME in MANPATH
    # Environment...
    setenv TEST_PLATFORM     linux32
    setenv TEST_PLATFORM_VER rhel4_i686
    setenv CC icc
    setenv CXX icpc
    setenv F77 ifort
    setenv FC ifort
    # TODO: Need to build with Intel 9.1 compilers due to problem with
    # exception handling on Intel 8.1 
    # IMPORTANT:  Module switch must be done before this script is called!! 
    ##  module switch compilers compilers/intel-9.1-f040-c046
    ##  module switch mpi mpi/openmpi-1.2.3_mx_intel-9.1-f040-c046
    # the following will go along with that module swap
    setenv CFLAGS "-O2 -Wl,-rpath,/projects/global/x86/compilers/intel/intel-9.1-cc-046/lib -Wl,-rpath,/apps/x86/mpi/openmpi/intel-9.1-f040-c046/openmpi-1.2.3_mx/lib" 
    setenv CXXFLAGS "-O2 -Wl,-rpath,/projects/global/x86/compilers/intel/intel-9.1-cc-046/lib -Wl,-rpath,/apps/x86/mpi/openmpi/intel-9.1-f040-c046/openmpi-1.2.3_mx/lib"
    setenv FFLAGS "-O2 -Wl,-rpath,/projects/global/x86/compilers/intel/intel-9.1-fc-040/lib -Wl,-rpath,/apps/x86/mpi/openmpi/intel-9.1-f040-c046/openmpi-1.2.3_mx/lib"
    setenv FCFLAGS "-O2 -Wl,-rpath,/projects/global/x86/compilers/intel/intel-9.1-fc-040/lib -Wl,-rpath,/apps/x86/mpi/openmpi/intel-9.1-f040-c046/openmpi-1.2.3_mx/lib"
    setenv BLAS_LIBS "$MKL_LIB/libmkl_ia32.a"
    setenv LAPACK_LIBS "$MKL_LIB/libmkl_lapack.a"
 
  else if ( $SNLSYSTEM == 'nwcc' ) then
    setenv USE_QSUB yes
    # Paths... 
    # Assume default environment includes MPIHOME in PATH and MANPATH 
    # Environment... 
    setenv TEST_PLATFORM     linux64
    setenv TEST_PLATFORM_VER rhel4_x86_64
    setenv CC icc
    setenv CXX icpc
    setenv F77 ifort
    setenv FC ifort
    setenv BLAS_LIBS "$MKL_LIB/libmkl_em64t.a"
    setenv LAPACK_LIBS "$MKL_LIB/libmkl_lapack.a"
 
  else if ( $SNLSYSTEM == 'thunderbird' ) then
    setenv USE_QSUB yes
    # Paths...
    # Assume default environment includes MPIHOME in PATH and MANPATH
    # NOTE that this build currently requires changing to MVAPICH module .
    # Environment...
    setenv TEST_PLATFORM     linux64 
    setenv TEST_PLATFORM_VER rhel4_x86_64
    setenv CC icc
    setenv CXX icpc
    setenv F77 ifort
    setenv FC ifort
    setenv LDFLAGS "-pthread -L$MKL_LIB -lguide"
    # TODO: need to build with MVAPICH, otherwise defaults are fine
    # module switch mpi/openmpi-1.2.4_ofed_intel-10.0-f025-c025 mpi/mvapich-0.9.8_ofed_intel-10.1-f015-c015
    echo "TBIRD WARNING:  insure that MVAPICH module is loaded instead of OPENMPI."
    setenv BLAS_LIBS "-L$MKL_LIB -lmkl_em64t"
    setenv LAPACK_LIBS "-L$MKL_LIB -lmkl_lapack"

  else if ( $SNLSYSTEM == 'redstorm' ) then
    setenv SVNHOME "/usr/local/unsupported"
    # Paths...
    #   Build either for service nodes (SN) or compute nodes (CN); if not set,
    #   default is SN
    if ( ${?RS_NODES} == 0 ) then
       setenv RS_NODES SN
    endif
    if ($RS_NODES == 'SN') then
      # This is a service-node build, on the Linux nodes; no MPI
      # Environment...
      setenv TEST_PLATFORM     linux64
      setenv TEST_PLATFORM_VER SuSE_Enterprise_Server_9_x86_64
      setenv CC pgcc
      setenv CXX pgCC
      setenv F77 pgf77
      setenv FC pgf90
      # TODO: need to change modules to build for service nodes not for
      # compute nodes:  
      #                module unload PrgEnv-pgi/2.0.41
      #                module load pgi
      echo "Red Storm WARNING:  insure that CN modules are replaced with SN modules"
      setenv USE_QSUB no
      setenv TEST_PARALLEL no
      setenv DAKOTA_CONFIG_OPT " --disable-mpi $DAKOTA_CONFIG_OPT"
      #setenv BLAS_LIBS "/opt/pgi/7.1.4/linux86-64/7.1/lib/libblas.a "
      #setenv LAPACK_LIBS "/opt/pgi/7.1.4/linux86-64/7.1/lib/liblapack.a "
    else if ($RS_NODES == 'CN') then
      # Paths...
      setenv MPIHOME $MPICH_DIR
      # Assume default environment includes MPIHOME in PATH and MANPATH
      # Environment...
      setenv TEST_PLATFORM    linux64
      setenv TEST_PLATFORM_VER Catamount
      setenv CC CC
      setenv CXX CC
      setenv F77 ftn
      setenv FC ftn
    endif

  endif
endif

# Final settings for everybody
if ( ${?TEST_SQA} == 0 ) then
  setenv TEST_SQA  $DAKOTA_ROOT/Dakota/test/sqa
endif
setenv MANPATH "$AUTOHOME/man:$SVNHOME/man:"$MANPATH
setenv PATH ".:$AUTOHOME/bin:$SVNHOME/bin:"$PATH

