function zp=griddata_perso(index,x,y,u,xp,yp,alpha,beta,gamma);
%GRIDDATA_PERSO - interpolates linearly a profile on a mesh
%
%   Usage:
%      zp=griddata_perso(index,x,y,u,xp,yp,alpha,beta,gamma)

zp=zeros(length(xp),1);
for n=1:length(xp),
   P=[xp(n) yp(n)];
   dist=sqrt((x-P(1)).^2+(y-P(2)).^2);
   posQ=find(dist==min(dist));
   if min(dist)==0,
      zp(n)=u(n);
   else
   	posQ=posQ(1);
      elems=find(index(:,1)==posQ | index(:,2)==posQ | index(:,3)==posQ);
   	for i=1:length(elems),
         el=elems(i);
         if isinpoly(P(1),P(2),x(index(el,:)),y(index(el,:)))==1,
            zp(n)=sum((alpha(el,:)).*u(index(el,:))')*P(1)+...
            sum((beta(el,:)).*u(index(el,:))')*P(2)+...
            sum((gamma(el,:)).*u(index(el,:))');
			end
      end
   end
end
