function dh1dh6_basic=GetNodalFunctionsDerivativesBasic(pentaelem,xyz_list,gauss_coord)
%GETNODALFUNCTIONSDERIVATIVESBASIC - return the values of the nodal functions derivatives on the current element
%
%   Usage:
%      dh1dh6_basic=GetNodalFunctionsDerivativesBasic(pentaelem,xyz_list,gauss_coord)
%
%   See also GETNODALFUNCTIONS, GETNODALFUNCTIONSDERIVATIVESPARAMS, GETNODALFUNCTIONSDERIVATIVESBASICSTOKES

num_grids=6;

%Get derivative values with respect to parametric coordinate system:
dh1dh6_param=GetNodalFunctionsDerivativesParams(pentaelem,gauss_coord); 
	
%Get Jacobian invert: 
Jinv=GetJacobianInvert(pentaelem,xyz_list, gauss_coord);
	
%Build dh1dh6_basic: 
% [dhi/dx]= Jinv'*[dhi/dr]
% [dhi/dy]       [dhi/ds]
% [dhi/dz]       [dhi/dzeta]

dh1dh6_basic=zeros(3,num_grids);	

for i=1:num_grids,
	dh1dh6_basic(1,i)=Jinv(1,1)*dh1dh6_param(1,i)+Jinv(2,1)*dh1dh6_param(2,i)+Jinv(3,1)*dh1dh6_param(3,i);
	dh1dh6_basic(2,i)=Jinv(1,2)*dh1dh6_param(1,i)+Jinv(2,2)*dh1dh6_param(2,i)+Jinv(3,2)*dh1dh6_param(3,i);
	dh1dh6_basic(3,i)=Jinv(1,3)*dh1dh6_param(1,i)+Jinv(2,3)*dh1dh6_param(2,i)+Jinv(3,3)*dh1dh6_param(3,i);
end
