C***********************************************************************
C Dempster-Shafer Evidence Theory implementation.
C Sandia National Laboratories 2006.
C
C At the present time, the Dempster-Shafer Evidence Theory implementation 
C is being distributed as part of the DAKOTA framework, under the DAKOTA GNU
C GPL (see the README, COPYRIGHT, and LICENSE file in the top Dakota 
C directory for more information).
C***********************************************************************
      SUBROUTINE CBPIIC(MAXINT,NCMB,NV,NI,IP,
     1     BPA,BPAC)
C      SUBROUTINE CBPIIC(MAXV,MAXINT,MAXCMB,NV,NI,IP,
C     1     BPA,BPAC)
C*****CALCULATE BASIC PROBABILITIES FOR INPUT INTERVAL COMBINATIONS
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION NI(NV),IP(NV)
      DIMENSION BPA(MAXINT*NV),BPAC(NCMB)
      WRITE(*,*) 'NV', NV
      WRITE(*,*) 'MAXINT', MAXINT
      DO 25 IINT=1,MAXINT
         DO 15 INNV=1,NV
C            WRITE(*,*) 'INTVL',IINT,'IINV',INNV,'BPA',BPA(IINT,INNV)
            WRITE(*,*) 'INTVL',IINT,'IINV',INNV,'BPA',
     1                 BPA((INNV-1)*MAXINT+IINT)
 15      CONTINUE
 25   CONTINUE
C
C*****INITIALIZE NUMBER OF INPUT INTERVAL COMBINATIONS
      ICMB=0
C*****INITIALIZE POINTER FOR FIRST VARIABLE TO ZERO
      IP(1)=0
C*****LOOP OVER VARIABLES
      DO 1000 IV=2,NV
C********INITIALIZE POINTER FOR CURRENT VARIABLE TO FIRST INPUT INTERVAL
         IP(IV)=1
 1000 CONTINUE
C*****INITIALIZE VARIABLE POINTER
      IVT=1
C*****BEGINNING OF COMPUTATION LOOP FOR INPUT INTERVALS
 2000 CONTINUE
C*****INCREMENT INTERVAL POINTER FOR CURRENT VARIABLE
      IP(IVT)=IP(IVT) + 1
C*****WHEN VALUE OF INTERVAL POINTER FOR CURRENT VARIABLE EXCEEDS NUMBER OF
C*****INTERVALS, ATTEMPT TO INCREMENT INTERVAL POINTER FOR NEXT VARIABLE
      IF (IP(IVT) .GT. NI(IVT)) THEN
C********RESET INTERVAL POINTER FOR CURRENT VARIABLE TO FIRST INTERVAL
         IP(IVT)=1
C********INCREMENT VARIABLE POINTER
         IVT=IVT + 1
C********TERMINATE LOOP WHEN VARIABLE POINTER EXCEEDS NUMBER OF VARIBLES
         IF (IVT .GT. NV) GO TO 8000
C********RE-EVALUATE INTERVAL POINTER FOR CURRENT VARIABLE
         GO TO 2000
      ENDIF
C*****REINITIALIZE VARIABLE POINTER
      IF (IVT .NE. 1) IVT=1
C*****INCREMENT NUMBER OF INPUT INTERVAL COMBINATIONS
      ICMB=ICMB + 1
C*****INITIALIZE BASIC PROBABILITY ASSIGNMENT FOR INPUT INTERVAL COMBINATION
      BPAC(ICMB)=1.0
C*****LOOP OVER VARIABLES
      DO 3000 IV=1,NV
C********ACCUMULATE BASIC PROBABILITY ASSIGNMENT FOR INPUT INTERVAL
C********COMBINATION
C	 WRITE(*,*) 'Variable', IV
C	 WRITE(*,*) 'Interva', IP(IV)
C	 WRITE(*,*) 'BPA', BPA(IP(IV),IV)
C	 WRITE(*,*) 'Combo number', ICMB 
C	 WRITE(*,*) 'BPAC', BPAC(ICMB)
C         BPAC(ICMB)=BPAC(ICMB) * BPA(IP(IV),IV)
         BPAC(ICMB)=BPAC(ICMB) * BPA((IV-1)*MAXINT+IP(IV))
C	 WRITE(*,*) 'BPAC 2nd time', BPAC(ICMB)
 3000 CONTINUE
      GO TO 2000
 8000 CONTINUE
      RETURN
      END
