/*!\file Gradjx
 * \brief: compute inverse method gradient
 */

#include "./Gradjx.h"

#undef __FUNCT__ 
#define __FUNCT__ "Gradjx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void Gradjx( Vec* pgrad_g, DataSet* elements,DataSet* nodes, DataSet* loads, DataSet* materials, 
		double* u_g, double* lambda_g, ParameterInputs* inputs,int analysis_type,char* control_type){

	int i;
	int gsize;
	int found;

	/*output: */
	Vec grad_g=NULL;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes, materials);

	/*Get size of matrix: */
	gsize=nodes->NumberOfDofs();

	/*Allocate grad_g: */
	grad_g=NewVec(gsize);

	/*Compute gradients: */
	elements->Gradj(grad_g, u_g,lambda_g,inputs,analysis_type,control_type);

	/*Assemble vector: */
	VecAssemblyBegin(grad_g);
	VecAssemblyEnd(grad_g);

	/*Assign output pointers: */
	*pgrad_g=grad_g;
}
