function elemvector = elemvector(varargin)
%ELEMVECVTOR - constructor for elemenvector object
%
%   Usage:
%      elemvector = elemvector(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	elemvector.nrows=NaN;
	elemvector.row_indices=NaN;
	elemvector.terms=NaN;
	elemvector=class(elemvector,'elemvector');
				
case 1
	argument=varargin{1};

	if isa(argument,'elemvector'),
		elemvector=argument;
	else
		if isnumeric(argument),
			numdof=argument;
			elemvector.nrows=numdof;
			elemvector.row_indices=zeros(numdof,1);
			elemvector.terms=zeros(numdof,1);
			elemvector=class(elemvector,'elemvector');
		elseif isstruct(argument),
			elemvector=class(argument,'elemvector');
		else
			error('elemvector constructor error message: input argument not yet supported.');
		end
	end
otherwise
	error('elemvector constructor error message: 0 of 1 argument only in input.');
end
