
import re
import math
import os
import types
import sys
from xml.dom import minidom, Node
from sets import Set
from exact_globals import *

#
# Don't regenerate these in 'escape()'.
#
identitymap = "".join([chr(n) for n in xrange(256)])
delchars = identitymap[:9] + chr(11) + chr(12) + identitymap[14:31] + chr(124)

def get_text(node):
  nodetext = ""
  for child in node.childNodes:
    if child.nodeType == Node.TEXT_NODE:
       nodetext = nodetext + child.nodeValue
  nodetext.strip()
  return str(nodetext)


def escape(s):
  """Replace special characters '&', "'", '<', '>' and '"' by XML entities."""
  s = s.replace("&", "&amp;") # Must be done first!
  s = s.replace("<", "&lt;")
  s = s.replace(">", "&gt;")
  s = s.translate(identitymap, delchars)
  #s = s.replace("'", "&apos;")
  #s = s.replace('"', "&quot;")
  return s



class XMLObjectBase(object):
    def __init__(self):
	self.path=None


    def reset(self):
	self.filename = "unknown"


    def initialize(self, node, performReset=True):
	"""
	Initialize the object with either a filename or a node of an 
	XML parsed tree.
	"""
	if global_data.debug:
	   print "XMLObjectBase::initialize",
	   if isinstance(node,types.StringType) or isinstance(node,types.UnicodeType):
	      print node
	   if self.path is not None:
	      print "Path " + self.path

	if performReset:
	   self.reset()
	
	if node is None:
	   return

	elif isinstance(node,types.StringType) or isinstance(node,types.UnicodeType):
	   #
	   # Load in from a file
	   #
	   if self.path is not None and self.path != "":
	      self.filename = self.path + "/" + node
	   else:
	      self.filename = node

	   if not os.path.exists(self.filename):
	      print ""
              print "ERROR: missing file \"" + node + "\" when reading XML object"
	      sys.exit(1)
	   self.path = os.path.dirname(node)
	   if self.path == "":
	      self.path = "./"
	   else:
	      self.path = self.path + "/"
	   #
	   # Parse XML
	   #
	   try:
              doc = minidom.parse(self.filename)
	   except:
	      print "ERROR: problem parsing XML file " + self.filename
	      raise
	   #
	   # Recursively call initialization, setting the current working
	   # directory to the directory where the config-info file is
	   # located.
	   #
	   try:
	      #currdir = os.path.abspath('')
	      #os.chdir(self.path)
	      self.parse_xml(doc.documentElement)
	   except:
	      #os.chdir(currdir)
	      raise
	   #os.chdir(currdir)
	else:
	   self.parse_xml(node)

