/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.36
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace OSGeo.GDAL {

using System;
using System.Runtime.InteropServices;

class GdalPINVOKE {

  protected class SWIGExceptionHelper {

    public delegate void ExceptionDelegate(string message);
    public delegate void ExceptionArgumentDelegate(string message, string paramName);

    static ExceptionDelegate applicationDelegate = new ExceptionDelegate(SetPendingApplicationException);
    static ExceptionDelegate arithmeticDelegate = new ExceptionDelegate(SetPendingArithmeticException);
    static ExceptionDelegate divideByZeroDelegate = new ExceptionDelegate(SetPendingDivideByZeroException);
    static ExceptionDelegate indexOutOfRangeDelegate = new ExceptionDelegate(SetPendingIndexOutOfRangeException);
    static ExceptionDelegate invalidCastDelegate = new ExceptionDelegate(SetPendingInvalidCastException);
    static ExceptionDelegate invalidOperationDelegate = new ExceptionDelegate(SetPendingInvalidOperationException);
    static ExceptionDelegate ioDelegate = new ExceptionDelegate(SetPendingIOException);
    static ExceptionDelegate nullReferenceDelegate = new ExceptionDelegate(SetPendingNullReferenceException);
    static ExceptionDelegate outOfMemoryDelegate = new ExceptionDelegate(SetPendingOutOfMemoryException);
    static ExceptionDelegate overflowDelegate = new ExceptionDelegate(SetPendingOverflowException);
    static ExceptionDelegate systemDelegate = new ExceptionDelegate(SetPendingSystemException);

    static ExceptionArgumentDelegate argumentDelegate = new ExceptionArgumentDelegate(SetPendingArgumentException);
    static ExceptionArgumentDelegate argumentNullDelegate = new ExceptionArgumentDelegate(SetPendingArgumentNullException);
    static ExceptionArgumentDelegate argumentOutOfRangeDelegate = new ExceptionArgumentDelegate(SetPendingArgumentOutOfRangeException);

    [DllImport("gdal_wrap", EntryPoint="SWIGRegisterExceptionCallbacks_Gdal")]
    public static extern void SWIGRegisterExceptionCallbacks_Gdal(
                                ExceptionDelegate applicationDelegate,
                                ExceptionDelegate arithmeticDelegate,
                                ExceptionDelegate divideByZeroDelegate, 
                                ExceptionDelegate indexOutOfRangeDelegate, 
                                ExceptionDelegate invalidCastDelegate,
                                ExceptionDelegate invalidOperationDelegate,
                                ExceptionDelegate ioDelegate,
                                ExceptionDelegate nullReferenceDelegate,
                                ExceptionDelegate outOfMemoryDelegate, 
                                ExceptionDelegate overflowDelegate, 
                                ExceptionDelegate systemExceptionDelegate);

    [DllImport("gdal_wrap", EntryPoint="SWIGRegisterExceptionArgumentCallbacks_Gdal")]
    public static extern void SWIGRegisterExceptionCallbacksArgument_Gdal(
                                ExceptionArgumentDelegate argumentDelegate,
                                ExceptionArgumentDelegate argumentNullDelegate,
                                ExceptionArgumentDelegate argumentOutOfRangeDelegate);

    static void SetPendingApplicationException(string message) {
      SWIGPendingException.Set(new System.ApplicationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArithmeticException(string message) {
      SWIGPendingException.Set(new System.ArithmeticException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingDivideByZeroException(string message) {
      SWIGPendingException.Set(new System.DivideByZeroException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIndexOutOfRangeException(string message) {
      SWIGPendingException.Set(new System.IndexOutOfRangeException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidCastException(string message) {
      SWIGPendingException.Set(new System.InvalidCastException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidOperationException(string message) {
      SWIGPendingException.Set(new System.InvalidOperationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIOException(string message) {
      SWIGPendingException.Set(new System.IO.IOException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingNullReferenceException(string message) {
      SWIGPendingException.Set(new System.NullReferenceException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOutOfMemoryException(string message) {
      SWIGPendingException.Set(new System.OutOfMemoryException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOverflowException(string message) {
      SWIGPendingException.Set(new System.OverflowException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingSystemException(string message) {
      SWIGPendingException.Set(new System.SystemException(message, SWIGPendingException.Retrieve()));
    }

    static void SetPendingArgumentException(string message, string paramName) {
      SWIGPendingException.Set(new System.ArgumentException(message, paramName, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArgumentNullException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentNullException(paramName, message));
    }
    static void SetPendingArgumentOutOfRangeException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentOutOfRangeException(paramName, message));
    }

    static SWIGExceptionHelper() {
      SWIGRegisterExceptionCallbacks_Gdal(
                                applicationDelegate,
                                arithmeticDelegate,
                                divideByZeroDelegate,
                                indexOutOfRangeDelegate,
                                invalidCastDelegate,
                                invalidOperationDelegate,
                                ioDelegate,
                                nullReferenceDelegate,
                                outOfMemoryDelegate,
                                overflowDelegate,
                                systemDelegate);

      SWIGRegisterExceptionCallbacksArgument_Gdal(
                                argumentDelegate,
                                argumentNullDelegate,
                                argumentOutOfRangeDelegate);
    }
  }

  protected static SWIGExceptionHelper swigExceptionHelper = new SWIGExceptionHelper();

  public class SWIGPendingException {
    [ThreadStatic]
    private static Exception pendingException = null;
    private static int numExceptionsPending = 0;

    public static bool Pending {
      get {
        bool pending = false;
        if (numExceptionsPending > 0)
          if (pendingException != null)
            pending = true;
        return pending;
      } 
    }

    public static void Set(Exception e) {
      if (pendingException != null)
        throw new ApplicationException("FATAL: An earlier pending exception from unmanaged code was missed and thus not thrown (" + pendingException.ToString() + ")", e);
      pendingException = e;
      lock(typeof(GdalPINVOKE)) {
        numExceptionsPending++;
      }
    }

    public static Exception Retrieve() {
      Exception e = null;
      if (numExceptionsPending > 0) {
        if (pendingException != null) {
          e = pendingException;
          pendingException = null;
          lock(typeof(GdalPINVOKE)) {
            numExceptionsPending--;
          }
        }
      }
      return e;
    }
  }


  protected class SWIGStringHelper {

    public delegate string SWIGStringDelegate(string message);
    static SWIGStringDelegate stringDelegate = new SWIGStringDelegate(CreateString);

    [DllImport("gdal_wrap", EntryPoint="SWIGRegisterStringCallback_Gdal")]
    public static extern void SWIGRegisterStringCallback_Gdal(SWIGStringDelegate stringDelegate);

    static string CreateString(string cString) {
      return cString;
    }

    static SWIGStringHelper() {
      SWIGRegisterStringCallback_Gdal(stringDelegate);
    }
  }

  static protected SWIGStringHelper swigStringHelper = new SWIGStringHelper();


  [DllImport("gdal_wrap", EntryPoint="CSharp_UseExceptions")]
  public static extern void UseExceptions();

  [DllImport("gdal_wrap", EntryPoint="CSharp_DontUseExceptions")]
  public static extern void DontUseExceptions();

  public class StringListMarshal : IDisposable {
    public readonly IntPtr[] _ar;
    public StringListMarshal(string[] ar) {
      _ar = new IntPtr[ar.Length+1];
      for (int cx = 0; cx < ar.Length; cx++) {
	      _ar[cx] = System.Runtime.InteropServices.Marshal.StringToHGlobalAnsi(ar[cx]);
      }
      _ar[ar.Length] = IntPtr.Zero;
    }
    public virtual void Dispose() {
	  for (int cx = 0; cx < _ar.Length-1; cx++) {
          System.Runtime.InteropServices.Marshal.FreeHGlobal(_ar[cx]);
      }
      GC.SuppressFinalize(this);
    }
  }


  [DllImport("gdal_wrap", EntryPoint="CSharp_StringListDestroy")]
  public static extern void StringListDestroy(IntPtr jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Debug")]
  public static extern void Debug(string jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Error")]
  public static extern void Error(int jarg1, int jarg2, string jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_PushErrorHandler__SWIG_0")]
  public static extern int PushErrorHandler__SWIG_0(string jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_PushErrorHandler__SWIG_1")]
  public static extern void PushErrorHandler__SWIG_1(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_PopErrorHandler")]
  public static extern void PopErrorHandler();

  [DllImport("gdal_wrap", EntryPoint="CSharp_ErrorReset")]
  public static extern void ErrorReset();

  [DllImport("gdal_wrap", EntryPoint="CSharp_EscapeString")]
  public static extern string EscapeString(int jarg1, string jarg2, int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetLastErrorNo")]
  public static extern int GetLastErrorNo();

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetLastErrorType")]
  public static extern int GetLastErrorType();

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetLastErrorMsg")]
  public static extern string GetLastErrorMsg();

  [DllImport("gdal_wrap", EntryPoint="CSharp_PushFinderLocation")]
  public static extern void PushFinderLocation(string jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_PopFinderLocation")]
  public static extern void PopFinderLocation();

  [DllImport("gdal_wrap", EntryPoint="CSharp_FinderClean")]
  public static extern void FinderClean();

  [DllImport("gdal_wrap", EntryPoint="CSharp_FindFile")]
  public static extern string FindFile(string jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ReadDir")]
  public static extern IntPtr ReadDir(string jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_SetConfigOption")]
  public static extern void SetConfigOption(string jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetConfigOption")]
  public static extern string GetConfigOption(string jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_CPLBinaryToHex")]
  public static extern string CPLBinaryToHex(int jarg1, IntPtr jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_CPLHexToBinary")]
  public static extern IntPtr CPLHexToBinary(string jarg1, out int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_Type_get")]
  public static extern int XMLNode_Type_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_Value_get")]
  public static extern string XMLNode_Value_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_Next_get")]
  public static extern IntPtr XMLNode_Next_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_Child_get")]
  public static extern IntPtr XMLNode_Child_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_new_XMLNode")]
  public static extern IntPtr new_XMLNode(string jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_delete_XMLNode")]
  public static extern void delete_XMLNode(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_SerializeXMLTree")]
  public static extern string XMLNode_SerializeXMLTree(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_SearchXMLNode")]
  public static extern IntPtr XMLNode_SearchXMLNode(HandleRef jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_GetXMLNode")]
  public static extern IntPtr XMLNode_GetXMLNode(HandleRef jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_GetXMLValue")]
  public static extern string XMLNode_GetXMLValue(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_AddXMLChild")]
  public static extern void XMLNode_AddXMLChild(HandleRef jarg1, HandleRef jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_RemoveXMLChild")]
  public static extern int XMLNode_RemoveXMLChild(HandleRef jarg1, HandleRef jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_AddXMLSibling")]
  public static extern void XMLNode_AddXMLSibling(HandleRef jarg1, HandleRef jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_CreateXMLElementAndValue")]
  public static extern IntPtr XMLNode_CreateXMLElementAndValue(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_CloneXMLTree")]
  public static extern IntPtr XMLNode_CloneXMLTree(HandleRef jarg1, HandleRef jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_SetXMLValue")]
  public static extern int XMLNode_SetXMLValue(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_XMLNode_StripXMLNamespace")]
  public static extern void XMLNode_StripXMLNamespace(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_MajorObject_GetDescription")]
  public static extern string MajorObject_GetDescription(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_MajorObject_SetDescription")]
  public static extern void MajorObject_SetDescription(HandleRef jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_MajorObject_GetMetadata")]
  public static extern IntPtr MajorObject_GetMetadata(HandleRef jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_MajorObject_SetMetadata__SWIG_0")]
  public static extern int MajorObject_SetMetadata__SWIG_0(HandleRef jarg1, IntPtr[] jarg2, string jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_MajorObject_SetMetadata__SWIG_1")]
  public static extern int MajorObject_SetMetadata__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_MajorObject_GetMetadataItem")]
  public static extern string MajorObject_GetMetadataItem(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_MajorObject_SetMetadataItem")]
  public static extern int MajorObject_SetMetadataItem(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Driver_ShortName_get")]
  public static extern string Driver_ShortName_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Driver_LongName_get")]
  public static extern string Driver_LongName_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Driver_HelpTopic_get")]
  public static extern string Driver_HelpTopic_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Driver_Create")]
  public static extern IntPtr Driver_Create(HandleRef jarg1, string jarg2, int jarg3, int jarg4, int jarg5, int jarg6, IntPtr[] jarg7);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Driver_CreateCopy")]
  public static extern IntPtr Driver_CreateCopy(HandleRef jarg1, string jarg2, HandleRef jarg3, int jarg4, IntPtr[] jarg5, Gdal.GDALProgressFuncDelegate jarg6, string jarg7);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Driver_Delete")]
  public static extern int Driver_Delete(HandleRef jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Driver_Rename")]
  public static extern int Driver_Rename(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Driver_Register")]
  public static extern int Driver_Register(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Driver_Deregister")]
  public static extern void Driver_Deregister(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorEntry_c1_set")]
  public static extern void ColorEntry_c1_set(HandleRef jarg1, short jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorEntry_c1_get")]
  public static extern short ColorEntry_c1_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorEntry_c2_set")]
  public static extern void ColorEntry_c2_set(HandleRef jarg1, short jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorEntry_c2_get")]
  public static extern short ColorEntry_c2_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorEntry_c3_set")]
  public static extern void ColorEntry_c3_set(HandleRef jarg1, short jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorEntry_c3_get")]
  public static extern short ColorEntry_c3_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorEntry_c4_set")]
  public static extern void ColorEntry_c4_set(HandleRef jarg1, short jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorEntry_c4_get")]
  public static extern short ColorEntry_c4_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_new_ColorEntry")]
  public static extern IntPtr new_ColorEntry();

  [DllImport("gdal_wrap", EntryPoint="CSharp_delete_ColorEntry")]
  public static extern void delete_ColorEntry(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_GCPX_set")]
  public static extern void GCP_GCPX_set(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_GCPX_get")]
  public static extern double GCP_GCPX_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_GCPY_set")]
  public static extern void GCP_GCPY_set(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_GCPY_get")]
  public static extern double GCP_GCPY_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_GCPZ_set")]
  public static extern void GCP_GCPZ_set(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_GCPZ_get")]
  public static extern double GCP_GCPZ_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_GCPPixel_set")]
  public static extern void GCP_GCPPixel_set(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_GCPPixel_get")]
  public static extern double GCP_GCPPixel_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_GCPLine_set")]
  public static extern void GCP_GCPLine_set(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_GCPLine_get")]
  public static extern double GCP_GCPLine_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_Info_set")]
  public static extern void GCP_Info_set(HandleRef jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_Info_get")]
  public static extern string GCP_Info_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_Id_set")]
  public static extern void GCP_Id_set(HandleRef jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCP_Id_get")]
  public static extern string GCP_Id_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_new_GCP")]
  public static extern IntPtr new_GCP(double jarg1, double jarg2, double jarg3, double jarg4, double jarg5, string jarg6, string jarg7);

  [DllImport("gdal_wrap", EntryPoint="CSharp_delete_GCP")]
  public static extern void delete_GCP(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_GCPX_get")]
  public static extern double GDAL_GCP_GCPX_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_GCPX_set")]
  public static extern void GDAL_GCP_GCPX_set(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_GCPY_get")]
  public static extern double GDAL_GCP_GCPY_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_GCPY_set")]
  public static extern void GDAL_GCP_GCPY_set(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_GCPZ_get")]
  public static extern double GDAL_GCP_GCPZ_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_GCPZ_set")]
  public static extern void GDAL_GCP_GCPZ_set(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_GCPPixel_get")]
  public static extern double GDAL_GCP_GCPPixel_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_GCPPixel_set")]
  public static extern void GDAL_GCP_GCPPixel_set(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_GCPLine_get")]
  public static extern double GDAL_GCP_GCPLine_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_GCPLine_set")]
  public static extern void GDAL_GCP_GCPLine_set(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_Info_get")]
  public static extern string GDAL_GCP_Info_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_Info_set")]
  public static extern void GDAL_GCP_Info_set(HandleRef jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_Id_get")]
  public static extern string GDAL_GCP_Id_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_Id_set")]
  public static extern void GDAL_GCP_Id_set(HandleRef jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_get_GCPX")]
  public static extern double GDAL_GCP_get_GCPX(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_set_GCPX")]
  public static extern void GDAL_GCP_set_GCPX(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_get_GCPY")]
  public static extern double GDAL_GCP_get_GCPY(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_set_GCPY")]
  public static extern void GDAL_GCP_set_GCPY(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_get_GCPZ")]
  public static extern double GDAL_GCP_get_GCPZ(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_set_GCPZ")]
  public static extern void GDAL_GCP_set_GCPZ(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_get_GCPPixel")]
  public static extern double GDAL_GCP_get_GCPPixel(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_set_GCPPixel")]
  public static extern void GDAL_GCP_set_GCPPixel(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_get_GCPLine")]
  public static extern double GDAL_GCP_get_GCPLine(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_set_GCPLine")]
  public static extern void GDAL_GCP_set_GCPLine(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_get_Info")]
  public static extern string GDAL_GCP_get_Info(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_set_Info")]
  public static extern void GDAL_GCP_set_Info(HandleRef jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_get_Id")]
  public static extern string GDAL_GCP_get_Id(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDAL_GCP_set_Id")]
  public static extern void GDAL_GCP_set_Id(HandleRef jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GCPsToGeoTransform")]
  public static extern int GCPsToGeoTransform(int jarg1, IntPtr jarg2, double[] jarg3, int jarg4);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_RasterXSize_get")]
  public static extern int Dataset_RasterXSize_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_RasterYSize_get")]
  public static extern int Dataset_RasterYSize_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_RasterCount_get")]
  public static extern int Dataset_RasterCount_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_delete_Dataset")]
  public static extern void delete_Dataset(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_GetDriver")]
  public static extern IntPtr Dataset_GetDriver(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_GetRasterBand")]
  public static extern IntPtr Dataset_GetRasterBand(HandleRef jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_GetProjection")]
  public static extern string Dataset_GetProjection(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_GetProjectionRef")]
  public static extern string Dataset_GetProjectionRef(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_SetProjection")]
  public static extern int Dataset_SetProjection(HandleRef jarg1, string jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_GetGeoTransform")]
  public static extern void Dataset_GetGeoTransform(HandleRef jarg1, double[] jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_SetGeoTransform")]
  public static extern int Dataset_SetGeoTransform(HandleRef jarg1, double[] jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_BuildOverviews")]
  public static extern int Dataset_BuildOverviews(HandleRef jarg1, string jarg2, int jarg3, IntPtr jarg4, Gdal.GDALProgressFuncDelegate jarg5, string jarg6);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_GetGCPCount")]
  public static extern int Dataset_GetGCPCount(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_GetGCPProjection")]
  public static extern string Dataset_GetGCPProjection(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_FlushCache")]
  public static extern void Dataset_FlushCache(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_AddBand")]
  public static extern int Dataset_AddBand(HandleRef jarg1, int jarg2, IntPtr[] jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_CreateMaskBand")]
  public static extern int Dataset_CreateMaskBand(HandleRef jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_GetFileList")]
  public static extern IntPtr Dataset_GetFileList(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_ReadRaster")]
  public static extern int Dataset_ReadRaster(HandleRef jarg1, int jarg2, int jarg3, int jarg4, int jarg5, IntPtr jarg6, int jarg7, int jarg8, int jarg9, int jarg10, int[] jarg11, int jarg12, int jarg13, int jarg14);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset_WriteRaster")]
  public static extern int Dataset_WriteRaster(HandleRef jarg1, int jarg2, int jarg3, int jarg4, int jarg5, IntPtr jarg6, int jarg7, int jarg8, int jarg9, int jarg10, int[] jarg11, int jarg12, int jarg13, int jarg14);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset___GetGCPs")]
  public static extern IntPtr Dataset___GetGCPs(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset___SetGCPs")]
  public static extern int Dataset___SetGCPs(HandleRef jarg1, int jarg2, IntPtr jarg3, string jarg4);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset___WriteCArrayItem_GDAL_GCP")]
  public static extern void Dataset___WriteCArrayItem_GDAL_GCP(HandleRef jarg1, IntPtr jarg2, int jarg3, HandleRef jarg4);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset___ReadCArrayItem_GDAL_GCP")]
  public static extern IntPtr Dataset___ReadCArrayItem_GDAL_GCP(HandleRef jarg1, IntPtr jarg2, int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset___AllocCArray_GDAL_GCP")]
  public static extern IntPtr Dataset___AllocCArray_GDAL_GCP(HandleRef jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Dataset___FreeCArray_GDAL_GCP")]
  public static extern void Dataset___FreeCArray_GDAL_GCP(HandleRef jarg1, IntPtr jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_XSize_get")]
  public static extern int Band_XSize_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_YSize_get")]
  public static extern int Band_YSize_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_DataType_get")]
  public static extern int Band_DataType_get(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetBlockSize")]
  public static extern void Band_GetBlockSize(HandleRef jarg1, out int jarg2, out int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetRasterColorInterpretation")]
  public static extern int Band_GetRasterColorInterpretation(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_SetRasterColorInterpretation")]
  public static extern int Band_SetRasterColorInterpretation(HandleRef jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetNoDataValue")]
  public static extern void Band_GetNoDataValue(HandleRef jarg1, out double jarg2, out int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_SetNoDataValue")]
  public static extern int Band_SetNoDataValue(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetRasterCategoryNames")]
  public static extern IntPtr Band_GetRasterCategoryNames(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_SetRasterCategoryNames")]
  public static extern int Band_SetRasterCategoryNames(HandleRef jarg1, IntPtr[] jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetMinimum")]
  public static extern void Band_GetMinimum(HandleRef jarg1, out double jarg2, out int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetMaximum")]
  public static extern void Band_GetMaximum(HandleRef jarg1, out double jarg2, out int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetOffset")]
  public static extern void Band_GetOffset(HandleRef jarg1, out double jarg2, out int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetScale")]
  public static extern void Band_GetScale(HandleRef jarg1, out double jarg2, out int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetStatistics")]
  public static extern int Band_GetStatistics(HandleRef jarg1, int jarg2, int jarg3, out double jarg4, out double jarg5, out double jarg6, out double jarg7);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_SetStatistics")]
  public static extern int Band_SetStatistics(HandleRef jarg1, double jarg2, double jarg3, double jarg4, double jarg5);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetOverviewCount")]
  public static extern int Band_GetOverviewCount(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetOverview")]
  public static extern IntPtr Band_GetOverview(HandleRef jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_Checksum")]
  public static extern int Band_Checksum(HandleRef jarg1, int jarg2, int jarg3, IntPtr jarg4, IntPtr jarg5);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_ComputeRasterMinMax")]
  public static extern void Band_ComputeRasterMinMax(HandleRef jarg1, double[] jarg2, int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_ComputeBandStats")]
  public static extern void Band_ComputeBandStats(HandleRef jarg1, double[] jarg2, int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_Fill")]
  public static extern int Band_Fill(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_FlushCache")]
  public static extern void Band_FlushCache(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetRasterColorTable")]
  public static extern IntPtr Band_GetRasterColorTable(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetColorTable")]
  public static extern IntPtr Band_GetColorTable(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_SetRasterColorTable")]
  public static extern int Band_SetRasterColorTable(HandleRef jarg1, HandleRef jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_SetColorTable")]
  public static extern int Band_SetColorTable(HandleRef jarg1, HandleRef jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetDefaultRAT")]
  public static extern IntPtr Band_GetDefaultRAT(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_SetDefaultRAT")]
  public static extern int Band_SetDefaultRAT(HandleRef jarg1, HandleRef jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetMaskBand")]
  public static extern IntPtr Band_GetMaskBand(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetMaskFlags")]
  public static extern int Band_GetMaskFlags(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_CreateMaskBand")]
  public static extern int Band_CreateMaskBand(HandleRef jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetHistogram")]
  public static extern int Band_GetHistogram(HandleRef jarg1, double jarg2, double jarg3, int jarg4, int[] jarg5, int jarg6, int jarg7, Gdal.GDALProgressFuncDelegate jarg8, string jarg9);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_GetDefaultHistogram")]
  public static extern int Band_GetDefaultHistogram(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6, Gdal.GDALProgressFuncDelegate jarg7, string jarg8);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_SetDefaultHistogram")]
  public static extern int Band_SetDefaultHistogram(HandleRef jarg1, double jarg2, double jarg3, int jarg4, HandleRef jarg5);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_ReadRaster")]
  public static extern int Band_ReadRaster(HandleRef jarg1, int jarg2, int jarg3, int jarg4, int jarg5, IntPtr jarg6, int jarg7, int jarg8, int jarg9, int jarg10, int jarg11);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Band_WriteRaster")]
  public static extern int Band_WriteRaster(HandleRef jarg1, int jarg2, int jarg3, int jarg4, int jarg5, IntPtr jarg6, int jarg7, int jarg8, int jarg9, int jarg10, int jarg11);

  [DllImport("gdal_wrap", EntryPoint="CSharp_new_ColorTable")]
  public static extern IntPtr new_ColorTable(int jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_delete_ColorTable")]
  public static extern void delete_ColorTable(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorTable_Clone")]
  public static extern IntPtr ColorTable_Clone(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorTable_GetPaletteInterpretation")]
  public static extern int ColorTable_GetPaletteInterpretation(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorTable_GetCount")]
  public static extern int ColorTable_GetCount(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorTable_GetColorEntry")]
  public static extern IntPtr ColorTable_GetColorEntry(HandleRef jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorTable_GetColorEntryAsRGB")]
  public static extern int ColorTable_GetColorEntryAsRGB(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorTable_SetColorEntry")]
  public static extern void ColorTable_SetColorEntry(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorTable_CreateColorRamp")]
  public static extern void ColorTable_CreateColorRamp(HandleRef jarg1, int jarg2, HandleRef jarg3, int jarg4, HandleRef jarg5);

  [DllImport("gdal_wrap", EntryPoint="CSharp_new_RasterAttributeTable")]
  public static extern IntPtr new_RasterAttributeTable();

  [DllImport("gdal_wrap", EntryPoint="CSharp_delete_RasterAttributeTable")]
  public static extern void delete_RasterAttributeTable(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_Clone")]
  public static extern IntPtr RasterAttributeTable_Clone(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_GetColumnCount")]
  public static extern int RasterAttributeTable_GetColumnCount(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_GetNameOfCol")]
  public static extern string RasterAttributeTable_GetNameOfCol(HandleRef jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_GetUsageOfCol")]
  public static extern int RasterAttributeTable_GetUsageOfCol(HandleRef jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_GetTypeOfCol")]
  public static extern int RasterAttributeTable_GetTypeOfCol(HandleRef jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_GetColOfUsage")]
  public static extern int RasterAttributeTable_GetColOfUsage(HandleRef jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_GetRowCount")]
  public static extern int RasterAttributeTable_GetRowCount(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_GetValueAsString")]
  public static extern string RasterAttributeTable_GetValueAsString(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_GetValueAsInt")]
  public static extern int RasterAttributeTable_GetValueAsInt(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_GetValueAsDouble")]
  public static extern double RasterAttributeTable_GetValueAsDouble(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_SetValueAsString")]
  public static extern void RasterAttributeTable_SetValueAsString(HandleRef jarg1, int jarg2, int jarg3, string jarg4);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_SetValueAsInt")]
  public static extern void RasterAttributeTable_SetValueAsInt(HandleRef jarg1, int jarg2, int jarg3, int jarg4);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_SetValueAsDouble")]
  public static extern void RasterAttributeTable_SetValueAsDouble(HandleRef jarg1, int jarg2, int jarg3, double jarg4);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_SetRowCount")]
  public static extern void RasterAttributeTable_SetRowCount(HandleRef jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_CreateColumn")]
  public static extern int RasterAttributeTable_CreateColumn(HandleRef jarg1, string jarg2, int jarg3, int jarg4);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTable_GetRowOfValue")]
  public static extern int RasterAttributeTable_GetRowOfValue(HandleRef jarg1, double jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ComputeMedianCutPCT")]
  public static extern int ComputeMedianCutPCT(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4, HandleRef jarg5, Gdal.GDALProgressFuncDelegate jarg6, string jarg7);

  [DllImport("gdal_wrap", EntryPoint="CSharp_DitherRGB2PCT")]
  public static extern int DitherRGB2PCT(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, Gdal.GDALProgressFuncDelegate jarg6, string jarg7);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ReprojectImage")]
  public static extern int ReprojectImage(HandleRef jarg1, HandleRef jarg2, string jarg3, string jarg4, int jarg5, double jarg6, double jarg7, Gdal.GDALProgressFuncDelegate jarg8, string jarg9);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ComputeProximity")]
  public static extern int ComputeProximity(HandleRef jarg1, HandleRef jarg2, IntPtr[] jarg3, Gdal.GDALProgressFuncDelegate jarg4, string jarg5);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterizeLayer")]
  public static extern int RasterizeLayer(HandleRef jarg1, int jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, int jarg7, HandleRef jarg8, IntPtr[] jarg9, Gdal.GDALProgressFuncDelegate jarg10, string jarg11);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Polygonize")]
  public static extern int Polygonize(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4, IntPtr[] jarg5, Gdal.GDALProgressFuncDelegate jarg6, string jarg7);

  [DllImport("gdal_wrap", EntryPoint="CSharp_SieveFilter")]
  public static extern int SieveFilter(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4, int jarg5, IntPtr[] jarg6, Gdal.GDALProgressFuncDelegate jarg7, string jarg8);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RegenerateOverviews")]
  public static extern int RegenerateOverviews(HandleRef jarg1, int jarg2, HandleRef jarg3, string jarg4, Gdal.GDALProgressFuncDelegate jarg5, string jarg6);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RegenerateOverview")]
  public static extern int RegenerateOverview(HandleRef jarg1, HandleRef jarg2, string jarg3, Gdal.GDALProgressFuncDelegate jarg4, string jarg5);

  [DllImport("gdal_wrap", EntryPoint="CSharp_AutoCreateWarpedVRT")]
  public static extern IntPtr AutoCreateWarpedVRT(HandleRef jarg1, string jarg2, string jarg3, int jarg4, double jarg5);

  [DllImport("gdal_wrap", EntryPoint="CSharp_new_Transformer")]
  public static extern IntPtr new_Transformer(HandleRef jarg1, HandleRef jarg2, IntPtr[] jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_delete_Transformer")]
  public static extern void delete_Transformer(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Transformer_TransformPoint__SWIG_0")]
  public static extern int Transformer_TransformPoint__SWIG_0(HandleRef jarg1, int jarg2, double[] jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Transformer_TransformPoint__SWIG_1")]
  public static extern int Transformer_TransformPoint__SWIG_1(HandleRef jarg1, double[] jarg2, int jarg3, double jarg4, double jarg5, double jarg6);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Transformer_TransformPoints")]
  public static extern int Transformer_TransformPoints(HandleRef jarg1, int jarg2, int jarg3, double[] jarg4, double[] jarg5, double[] jarg6, double[] jarg7);

  [DllImport("gdal_wrap", EntryPoint="CSharp_VersionInfo")]
  public static extern string VersionInfo(string jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_AllRegister")]
  public static extern void AllRegister();

  [DllImport("gdal_wrap", EntryPoint="CSharp_GDALDestroyDriverManager")]
  public static extern void GDALDestroyDriverManager();

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetCacheMax")]
  public static extern int GetCacheMax();

  [DllImport("gdal_wrap", EntryPoint="CSharp_SetCacheMax")]
  public static extern void SetCacheMax(int jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetCacheUsed")]
  public static extern int GetCacheUsed();

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetDataTypeSize")]
  public static extern int GetDataTypeSize(int jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_DataTypeIsComplex")]
  public static extern int DataTypeIsComplex(int jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetDataTypeName")]
  public static extern string GetDataTypeName(int jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetDataTypeByName")]
  public static extern int GetDataTypeByName(string jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetColorInterpretationName")]
  public static extern string GetColorInterpretationName(int jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetPaletteInterpretationName")]
  public static extern string GetPaletteInterpretationName(int jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_DecToDMS")]
  public static extern string DecToDMS(double jarg1, string jarg2, int jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp_PackedDMSToDec")]
  public static extern double PackedDMSToDec(double jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_DecToPackedDMS")]
  public static extern double DecToPackedDMS(double jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ParseXMLString")]
  public static extern IntPtr ParseXMLString(string jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_SerializeXMLTree")]
  public static extern string SerializeXMLTree(HandleRef jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetDriverCount")]
  public static extern int GetDriverCount();

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetDriverByName")]
  public static extern IntPtr GetDriverByName(string jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GetDriver")]
  public static extern IntPtr GetDriver(int jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_Open")]
  public static extern IntPtr Open(string jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_OpenShared")]
  public static extern IntPtr OpenShared(string jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_IdentifyDriver")]
  public static extern IntPtr IdentifyDriver(string jarg1, IntPtr[] jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp_GeneralCmdLineProcessor")]
  public static extern IntPtr GeneralCmdLineProcessor(IntPtr[] jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp___WriteCArrayItem_GDAL_GCP")]
  public static extern void __WriteCArrayItem_GDAL_GCP(IntPtr jarg1, int jarg2, HandleRef jarg3);

  [DllImport("gdal_wrap", EntryPoint="CSharp___ReadCArrayItem_GDAL_GCP")]
  public static extern IntPtr __ReadCArrayItem_GDAL_GCP(IntPtr jarg1, int jarg2);

  [DllImport("gdal_wrap", EntryPoint="CSharp___AllocCArray_GDAL_GCP")]
  public static extern IntPtr __AllocCArray_GDAL_GCP(int jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp___FreeCArray_GDAL_GCP")]
  public static extern void __FreeCArray_GDAL_GCP(IntPtr jarg1);

  [DllImport("gdal_wrap", EntryPoint="CSharp_DriverUpcast")]
  public static extern IntPtr DriverUpcast(IntPtr objectRef);

  [DllImport("gdal_wrap", EntryPoint="CSharp_DatasetUpcast")]
  public static extern IntPtr DatasetUpcast(IntPtr objectRef);

  [DllImport("gdal_wrap", EntryPoint="CSharp_BandUpcast")]
  public static extern IntPtr BandUpcast(IntPtr objectRef);

  [DllImport("gdal_wrap", EntryPoint="CSharp_ColorTableUpcast")]
  public static extern IntPtr ColorTableUpcast(IntPtr objectRef);

  [DllImport("gdal_wrap", EntryPoint="CSharp_RasterAttributeTableUpcast")]
  public static extern IntPtr RasterAttributeTableUpcast(IntPtr objectRef);
}

}
