/*!\file:  Material.h
 * \brief abstract class for Material object
 */ 


#ifndef _MATERIAL_H_
#define _MATERIAL_H_

#include "./Object.h"
#include "./ParameterInputs.h"
#include "../toolkits/toolkits.h"

class Material: public Object{

	public: 
		virtual       ~Material(){};
		virtual void  Echo()=0;
		virtual int   GetId()=0;
		virtual int   MyRank()=0;
		virtual void  Marshall(char** pmarshalled_dataset)=0;
		virtual int   MarshallSize()=0;
		virtual char* GetName()=0;
		virtual void  Demarshall(char** pmarshalled_dataset)=0;
		virtual void  UpdateFromInputs(ParameterInputs* inputs)=0;
		int           Enum();
		
};
#endif
