/*  _________________________________________________________________________
 *
 *  EXACT: An Experimental Algorithmics Computational Toolkit.
 *  Copyright (c) 2007, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README file in the top source directory.
 *  _________________________________________________________________________
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#define X 1024 * 1024

int main (int argc, char **argv) {
    char *a = NULL;
    int i;
    printf("pid = %d\n", (int) getpid());
    printf("argc = %d\n", argc);
    for (i = 0; i< argc; i++)
	printf("argv[%d] = %s\n", i, argv[i]);
    printf("allocing");
    for (i=1; i< 20; i++) {
	if ((a = (char *) realloc( a, (size_t) (i * X))) == NULL) {
	  printf("realloc failed at %d\n", (i*X));
	  exit(1);
	}
	printf(">");
	fflush(stdout);
	sleep(1);
    }
    for (i=20; i> 0; i--) {
	if ((a = (char *) realloc(a, (i * X))) == NULL) {
	  printf("realloc failed at %d\n", (i*X));
	  exit(1);
	}
	printf("<");
	fflush(stdout);
	sleep(1);
    }
    printf("\n");
    exit(0);
}
