dnl @synopsis AX_CXX_HAVE_STD_COUNT
dnl
dnl Probes the C++ compiler to determine whether the version of the STL
dnl it uses makes std::count() available.
dnl
dnl @author Shannon Brown <slbrow@sandia.gov>
dnl @category Cxx
dnl @license GPL2
dnl @version 2006-02-15

AC_DEFUN([AX_CXX_HAVE_STD_COUNT],
[AC_CACHE_CHECK(whether the C++ compiler has std::count(),
ax_cv_cxx_have_std_count,
[AC_REQUIRE([AC_CXX_NAMESPACES])
 AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_TRY_COMPILE([#include <algorithm>
#ifdef HAVE_NAMESPACES
using namespace std;
#endif],[char array[] = "test";
int i = count(array, array + 5, 't');],
 ax_cv_cxx_have_std_count=yes, ax_cv_cxx_have_std_count=no)
 AC_LANG_RESTORE
])
 if test "x$ax_cv_cxx_have_std_count" = xyes; then
   AC_DEFINE([HAVE_STD_COUNT],[1],
	     [Define if you have an STL-conforming std::count().])
 fi
])dnl
