function beamelem = beamelem(varargin)
%BEAMELEM - contructor for beamelem objects
%
%   Usage:
%      beamelem = beamelem(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	beamelem.type='beamelem';
	beamelem.id=NaN;
	beamelem.matid=NaN;
	beamelem.g=zeros(2,1);
	beamelem.h=zeros(2,1);
	beamelem.s=zeros(2,1);
	beamelem.b=zeros(2,1);
	beamelem.k=zeros(2,1);
	beamelem.onbed=NaN;
	beamelem.onsurface=NaN;
	beamelem=class(beamelem,'beamelem');
				
case 1
	%If single argument of class beamelem, we have a copy constructor. 
	if (isa(varargin{1},'beamelem'))
		beamelem = varargin{1};
	else
		error('beamelem constructor error message: copy constructor called on a non ''beamelem'' class object');
	end 
otherwise
	error('beamelem constructor error message: 0 of 1 argument only in input.');
end
