function plot_drivingstress(md,options_structure,width,i);
%PLOT_DRIVINGSTRESS - plot driving stress
%
%   Usage:
%      plot_drivingstress(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%get driving stress
[sx sy s]=drivingstress(md);

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);
[dstress isongrid]=processdata(md,s,options_structure);
dstress=dstress/1000;

%plot mesh quivervel
subplot(width,width,i); 

%edgecolor?
if ~isnan(options_structure.edgecolor),
	edgecolor=options_structure.edgecolor;
else
	edgecolor='none';
end

%element data
if ~isongrid
	if is2d
		A=elements(:,1); B=elements(:,2); C=elements(:,3); 
		patch( 'Faces', [A B C], 'Vertices', [x y z],'CData', dstress,'FaceColor','flat','EdgeColor',edgecolor);
	else
		A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
		patch( 'Faces', [A B C], 'Vertices', [x y z],'CData', dstress,'FaceColor','flat','EdgeColor',edgecolor);
		patch( 'Faces', [D E F], 'Vertices', [x y z],'CData', dstress,'FaceColor','flat','EdgeColor',edgecolor);
		patch( 'Faces', [A B E D], 'Vertices', [x y z],'CData', dstress,'FaceColor','flat','EdgeColor',edgecolor);
		patch( 'Faces', [B E F C ], 'Vertices', [x y z],'CData', dstress,'FaceColor','flat','EdgeColor',edgecolor);
		patch( 'Faces', [C A D F ], 'Vertices', [x y z],'CData', dstress,'FaceColor','flat','EdgeColor',edgecolor);
	end
%grid data
elseif isongrid
	if is2d
		A=elements(:,1); B=elements(:,2); C=elements(:,3); 
		patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', dstress,'FaceColor','interp','EdgeColor',edgecolor);
	else
		if options_structure.layer>=1,
			A=elements(:,1); B=elements(:,2); C=elements(:,3); 
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', dstress,'FaceColor','interp','EdgeColor',edgecolor);
		else
			A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', dstress,'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', dstress,'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', dstress,'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', dstress,'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', dstress,'FaceColor','interp','EdgeColor',edgecolor);
		end
	end
end

%apply options
if isnan(options_structure.title)
	options_structure.title='Driving stress [kPa]';
end 
applyoptions(md,dstress,options_structure);
