function expmaster(newfile,varargin)
%EXPMASTER - allow to create, modify, add, cut, .. segments of domain outline together
%
%   this routine is used to create, modify, cut,... an Argus file (.exp)
%
%   expmaster(newprofile)
%      creation of an argus file newprofile
%
%   expmaster(newprofile,oldprofile)
%      the modification of the file oldprofile will be saved in newprofile
%
%   expmaster(newprofile,oldprofile1,oldprofile2,...)
%      the modification of the files oldprofile* will be saved in newprofile
%
%   Usage:
%      expmaster(newfile,varargin)
%
%   See also EXPDOC

%Some checks
if ~nargin | nargout
	error('expmaster usage: expmaster(newfile,varargin)')
elseif exist(newfile),
	choice=input(['A file ' newfile ' already exists, do you want to modify it? (y/n)'],'s');
	if ~strcmpi(choice,'y'),
		error('no modification done ... exiting');
	end
end

%put all the argus profiles given in input in one structure A
A=struct([]);
numprofiles=0;
numpoints=0;
closed=[];
if nargin>1,
	isexist=1;
	for i=1:nargin-1
		filename=varargin{i};
		if ~exist(filename),
			error(['expmaster error message:, ' filename ' does not exist. Exiting...']);
		else
			%read file
			B=expread(filename,1);
			%go through all profiles of B
			for i=1:size(B,2)
				%plug profile in A
				if numprofiles
					A(numprofiles+1)=B(i);
				else
					A=B(i);
				end
				%update numprofiles and numpoints
				numpoints=numpoints+length(B(i).x);
				numprofiles=numprofiles+1;
				%figure out if the profile is closed or not
				if (B(i).x(1)==B(i).x(end) & B(i).y(1)==B(i).y(end))
					closed(numprofiles)=1;
				else
					closed(numprofiles)=0;
				end
			end
		end
	end
else
	isexist=0;
end

%Get root of newfile
[path root ext ver]=fileparts(newfile);

%Figure out how nany plots have been done so far 
g=get(gca,'children'); 
prevplot=length(g);
prevplot2=prevplot;

%plot existing profile if any
hold on
if numprofiles
	for i=1:numprofiles
		plot(A(i).x,A(i).y,'-r','MarkerSize',10);
		prevplot2=prevplot2+1;
	end
end

%Build backup structre for do and redo
backup=cell(1,3);
backup{1,1}=A;
backup{1,2}=numprofiles;
backup{1,3}=numpoints;
backup{1,4}=closed;

loop=1;
counter=1;
while loop

	%is there a profile in A?
	if isexist

		%Go through A and rule out the empty profiles
		list=[];
		for i=1:size(A,2);
			if length(A(i).x)==0
				list(end+1)=i;
				numprofiles=numprofiles-1;
			end
		end
		A(list)=[];
		closed(list)=[];

		%display menu
		title('Main Menu','FontSize',14);
		button=menu('Menu','add a profile',...  %1
		'remove a profile',...                  %2
		'modify the position of a point',...    %3
		'add points inside a profile',...       %4
		'add points at the end of a profile',...%5
		'remove points',...                     %6
		'remove several points',...             %7
		'cut a segment',...                     %8
		'cut a large area',...                  %9
		'merge profiles',...                    %10
		'close profile',...                     %11
		'undo',...                              %12
		'redo',...                              %13
		'quit');                                %14


		%UNDO??
		if button==12;
			if counter==1
				disp('Already at oldest change');
			else
				counter=counter-1;
				A=backup{counter,1};
				numprofiles=backup{counter,2};
				numpoints=backup{counter,3};
				closed=backup{counter,4};
			end
		end

		%REDO??
		if button==13
			if counter==size(backup,1)
				disp('Already at newest change');
			else
				counter=counter+1;
				A=backup{counter,1};
				numprofiles=backup{counter,2};
				numpoints=backup{counter,3};
				closed=backup{counter,4};
			end
		end

		switch button

		case 1

			[A,numprofiles,numpoints,closed]=addprofile(A,numprofiles,numpoints,closed,prevplot2,root);
			counter=counter+1;
			backup{counter,1}=A;
			backup{counter,2}=numprofiles;
			backup{counter,3}=numpoints;
			backup{counter,4}=closed;

		case 2

			[A,numprofiles,numpoints,closed]=removeprofile(A,numprofiles,numpoints,closed,prevplot2,root);
			counter=counter+1;
			backup{counter,1}=A;
			backup{counter,2}=numprofiles;
			backup{counter,3}=numpoints;
			backup{counter,4}=closed;

		case 3

			[A,numprofiles,numpoints,closed]=modifyposition(A,numprofiles,numpoints,closed,prevplot,root);
			counter=counter+1;
			backup{counter,1}=A;
			backup{counter,2}=numprofiles;
			backup{counter,3}=numpoints;
			backup{counter,4}=closed;

		case 4

			[A,numprofiles,numpoints,closed]=addinsideprofile(A,numprofiles,numpoints,closed,prevplot,root);
			counter=counter+1;
			backup{counter,1}=A;
			backup{counter,2}=numprofiles;
			backup{counter,3}=numpoints;
			backup{counter,4}=closed;

		case 5

			[A,numprofiles,numpoints,closed]=addendprofile(A,numprofiles,numpoints,closed,prevplot2,root);
			counter=counter+1;
			backup{counter,1}=A;
			backup{counter,2}=numprofiles;
			backup{counter,3}=numpoints;
			backup{counter,4}=closed;

		case 6

			[A,numprofiles,numpoints,closed]=removepoints(A,numprofiles,numpoints,closed,prevplot,root);
			counter=counter+1;
			backup{counter,1}=A;
			backup{counter,2}=numprofiles;
			backup{counter,3}=numpoints;
			backup{counter,4}=closed;

		case 7

			[A,numprofiles,numpoints,closed]=removeseveralpoints(A,numprofiles,numpoints,closed,prevplot,root);
			counter=counter+1;
			backup{counter,1}=A;
			backup{counter,2}=numprofiles;
			backup{counter,3}=numpoints;
			backup{counter,4}=closed;

		case 8

			[A,numprofiles,numpoints,closed]=cutprofile(A,numprofiles,numpoints,closed,prevplot,root);
			counter=counter+1;
			backup{counter,1}=A;
			backup{counter,2}=numprofiles;
			backup{counter,3}=numpoints;
			backup{counter,4}=closed;

		case 9

			[A,numprofiles,numpoints,closed]=cutarea(A,numprofiles,numpoints,closed,prevplot,root);
			counter=counter+1;
			backup{counter,1}=A;
			backup{counter,2}=numprofiles;
			backup{counter,3}=numpoints;
			backup{counter,4}=closed;

		case 10

			[A,numprofiles,numpoints,closed]=mergeprofiles(A,numprofiles,numpoints,closed,prevplot,root);
			counter=counter+1;
			backup{counter,1}=A;
			backup{counter,2}=numprofiles;
			backup{counter,3}=numpoints;
			backup{counter,4}=closed;


		case 11

			[A,numprofiles,numpoints,closed]=closeprofile(A,numprofiles,numpoints,closed,prevplot,root);
			counter=counter+1;
			backup{counter,1}=A;
			backup{counter,2}=numprofiles;
			backup{counter,3}=numpoints;
			backup{counter,4}=closed;

		%QUIT
		case 14

			loop=0;

		otherwise

			%do nothing

		end

    %no argus file has been given in input, go to addcontour directly
	else
		[A,numprofiles,numpoints,closed]=addprofile(A,numprofiles,numpoints,closed,prevplot2,root);
		counter=counter+1;
		backup{counter,1}=A;
		backup{counter,2}=numprofiles;
		backup{counter,3}=numpoints;
		backup{counter,4}=closed;
		isexist=1;
	 end

	 %Now erase all that have been done and plot the new structure A as it is
	 undoplots(prevplot);
	if numprofiles
		for i=1:numprofiles
			plot(A(i).x,A(i).y,'-r','MarkerSize',10);
			prevplot2=prevplot2+1;
		end
	end
end

hold off

%write contour using expwrite
title('New file written, exiting','FontSize',14);
if isempty(A)
	disp('Profile empty, no file written')
else
	expwrite(A,newfile);
end
