/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

/**
 * \file Cobyla2.h
 *
 * Defines the coliny::Cobyla class.
 */

#ifndef coliny_Cobyla_h
#define coliny_Cobyla_h

#include <acro_config.h>
#ifdef ACRO_USING_COBYLA

#include <colin/colin.h>
#include <colin/ColinUtilib.h>
#include <colin/StdOptSolver.h>

namespace coliny {

using colin::real;
using utilib::BasicArray;

/** An interface to the COBYLA2 direct search method.
  *
  * This interface uses the utilib::BasicArray class to avoid copying between
  * this C++ and COBYLA's Fortran code.
  * 
  */
class Cobyla : public colin::StdOptSolver<BasicArray<double>,colin::AppResponse_Utilib>,
                                        protected colin::AppResponseAnalysis
{
public:

  /// Constructor
  Cobyla();

  ///
  void reset();

  ///
  void minimize();

  /// The function used to compute the constraints and objective
  static void calcfc(int n, int m, double* x, double* f, double* con );

protected:

  ///
  void initialize_best_point()
	{
	if ((best().point.size() > 0) &&
	    (best().point.size() != problem.num_real_params()))
	   EXCEPTION_MNGR(std::runtime_error, "initialize_best_point - user-provided best point has length " << best().point.size() << " but the problem size is " << problem.num_real_params() << std::endl);
        best().point.resize(problem.num_real_params());
	}

  ///
  double step_tolerance;

  ///
  double initial_step;

  ///
  BasicArray<double> x;

  ///
  static BasicArray<double> calcfc_point;

  ///
  static BasicArray<real> calcfc_cvec;

  ///
  static real calcfc_value;

  ///
  static BasicArray<real> clower;

  ///
  static BasicArray<real> cupper;

  ///
  static BasicArray<real> blower;

  ///
  static BasicArray<real> bupper;

  ///
  static colin::OptProblem<BasicArray<double>, colin::AppResponse_Utilib>* calcfc_problem;
};

} // namespace coliny
#endif

#endif
