/*
================================================================================
    PROJECT:

        Eddy C++ Logging

    CONTENTS:

        Definition of logging project detail macros.

    NOTES:



    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Fri Mar 04 12:22:09 2005 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains various detail macros for use with the logging project.
 */


/*
================================================================================
Create a Group for All Developer Macros
================================================================================
*/
/**
 * \defgroup dev_macros Developer Macro Interface
 */



/*
================================================================================
Prevent Multiple Inclusions
================================================================================
*/
#ifndef EDDY_LOGGING_DETAIL_MACROS_HPP
#define EDDY_LOGGING_DETAIL_MACROS_HPP





/*
================================================================================
Conditional Inclusion
================================================================================
*/
#ifdef EDDY_LOGGING_ON



/*
================================================================================
Includes
================================================================================
*/
#include "../include/config.hpp"





/*
================================================================================
Conditional Macroo Definitions
================================================================================
*/



#else // ifndef EDDY_LOGGING_ON



/*
================================================================================
End of Conditional Inclusion
================================================================================
*/
#endif



/*
================================================================================
Non-Conditional Macro Definitions
================================================================================
*/



/*
================================================================================
Include Inlined Functions File
================================================================================
*/
// Not using an Inlined Functions File.



/*
================================================================================
End of Multiple Inclusion Check
================================================================================
*/
#endif // EDDY_LOGGING_DETAIL_MACROS_HPP
