function [ K_ff, K_fs] = reducematrixfromgtof(K_gg, G_mn, flag_u_s,uset);
% REDUCEMATRIXFROMGTOF [K_ff, K_fs] = Reducematrixfromgtof( K_gg, G_mn, flag_u_s )
% Reduces a matrix from g-size to f-size
% 
% Input:
% 	K_gg		Matrix in g-size
%	G_mn		Reduction matrix 
%	flag_u_s	flag indicating whether K_fs is calculated or not
%				=0 K_fs is not calculated, an empty matrix is returned
%				=1 K_fs is calculated and returned
% Output:
%	K_ff		Reduced system tangent matrix f-size x f-size
%   K_fs		Reduced sytem tangent matrix f-size x s-size
%
% Input from global workspace:
%
%	uset      	uset.pv_*  partitioning vector
%				uset.*size size 
%                          *=n,m etc., see Builduset
%
% Called by  sol101 (ms), Normalmodes (ms), Tangentmatrixheat (mf)
% Calls  Reducematrix (mf)
% where ms= m-script, mf= m-function, mex= executable function (c-code)
%
% The g-set is partitioned as follows
%   g = n + m
%  		n = f + s
%   g 	all system degrees of freedom (dof)
%   m 	multi-point constraint dofs to be condensed out
%   n   remaining dof after m-set is condensed from the g-set
%   s   boundary condition dofs (single point constraints)
%   f   remaining free dofs after s-set is eliminated from the n-set
%

% 	Reduce matrix from g-size to n-size

K_nn= Reducematrix( K_gg, G_mn, uset.pv_m, uset.pv_n, uset.msize, 2 );

%  	Reduce matrix from n-size to f-size

if  uset.ssize>0  
	K_ff= K_nn(uset.pv_f, uset.pv_f);
	if  flag_u_s 
		K_fs= K_nn(uset.pv_f,uset.pv_s);
	else
		K_fs=[];
	end
else
	K_ff= K_nn;
	K_fs=[];
end
