function md=qmu(md,package)
%INPUT function md=qmu(md,package)
%Deal with coupled ISSM or Cielo/ Dakota runs, to do sensitivity analyses.

%first create temporary directory in which we will work
% qmudir=['qmu_' datestr(now,'yyyymmdd_HHMMSS')];
qmudir='qmu';
if exist(qmudir,'dir')
    overwrite=input('Overwrite existing ''qmu'' directory? Y/N [N]: ', 's');
    if strncmpi(overwrite,'y',1)
        system(['rm -rf ' qmudir]);
    else
        error('Existing ''qmu'' directory not overwritten');
    end
end
mkdir(qmudir)
cd(qmudir)
system('cp $ISSM_DIR/startup.m .');

%save our model in qmu so that it can be repeatedly used by Dakota.
save Qmu.model md

%create m and in files for dakota
dakota_in_data(md,'qmu',package);

%call dakota
system('dakota -i qmu.in -o qmu.out -e qmu.err');

%parse inputs and results from dakota
[method,dvar,dresp_in]=dakota_in_parse('qmu.in');
md.dakotaresults.method   =method;
md.dakotaresults.dvar     =dvar;
md.dakotaresults.dresp_in =dresp_in;
[method,dresp_out,scm,pcm,srcm,prcm]=dakota_out_parse('qmu.out');
md.dakotaresults.dresp_out=dresp_out;
[method,dresp_dat                  ]=dakota_out_parse('dakota_tabular.dat');
md.dakotaresults.dresp_dat=dresp_dat;
md.dakotaresults.scm      =scm;
md.dakotaresults.pcm      =pcm;
md.dakotaresults.srcm     =srcm;
md.dakotaresults.prcm     =prcm;

%save input and output files into model
md.dakotain =readfile('qmu.in');
md.dakotaout=readfile('qmu.out');
md.dakotadat=readfile('dakota_tabular.dat');
	
%get out of local directory and erase
cd ../
% system(['rm -rf ' qmudir]);
