/*
================================================================================
    PROJECT:

        Eddy C++ Utilities Project

    CONTENTS:

        Proprietary Version of the Eddy Debug Scope Project macros.

    NOTES:

        This implementation of the Eddy Debug Scope project macros is a null
        implementation of code that must otherwise be "LGPL'ed" because it is
        based on another LGPL licensed library.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Mon Feb 20 13:52:29 2006 - Original Version (JE)

================================================================================
*/



/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the proprietary implementation of the Eddy Debug Scope
 *        library.
 */




/*
================================================================================
Prevent Multiple Inclusions
================================================================================
*/
#ifndef EDDY_UTILITIES_EDDY_DEBUGSCOPE_P_HPP
#define EDDY_UTILITIES_EDDY_DEBUGSCOPE_P_HPP







/*
================================================================================
Includes
================================================================================
*/






/*
================================================================================
Preprocessor Definitions and Macros
================================================================================
*/
/// Expands to nothing in the proprietary implementation.
#define EDDY_DEBUG(a, b)

/// Expands to nothing in the proprietary implementation.
#define EDDY_WARNING(a, b)

/// Expands to nothing in the proprietary implementation.
#define EDDY_ASSERT(a)

/// Expands to nothing in the proprietary implementation.
#define EDDY_DEBUGSCOPE(a)

/// Expands to nothing in the proprietary implementation.
#define EDDY_FUNC_DEBUGSCOPE

/// Expands to nothing in the proprietary implementation.
#define EDDY_DEBUGSIGNAL(a)

/// Expands to nothing in the proprietary implementation.
#define EDDY_TRACESCOPE()

/// Expands to nothing in the proprietary implementation.
#define EDDY_MESSAGE(a, b)

/// Expands to nothing in the proprietary implementation.
#define EDDY_DEBUGEXEC(a)










/*
================================================================================
Namespace Using Directives - DISCOURAGED!!
================================================================================
*/






/*
================================================================================
Include Inlined Methods File
================================================================================
*/
// Not using an inlined functions file.




/*
================================================================================
End of Multiple Inclusion Check
================================================================================
*/
#endif // EDDY_UTILITIES_EDDY_DEBUGSCOPE_P_HPP
