function displayparallel(md)
%DISPLAYPARALLEL - display parallel computation parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays all fields related to
%   parallel computation from model md, only if requested.
%
%   Usage:
%      displayparallel(md)

disp(sprintf('      ''%s''','parallelisation'));
disp(sprintf('         cluster: %s      (set to ''cluster_name'' to run in cluster, ''none'' to run serially)',md.cluster));
disp(sprintf('         np: %i      (number of CPUS requested on cluster)',md.np));
disp(sprintf('         exclusive: %i      (set to 1 if CPUS used are not to be shared with other users, 0 otherwise)',md.exclusive));
disp(sprintf('         time: %i      (amount of time requested on cluster)',md.time)); 
disp(sprintf('         alloc_cleanup: %i      (allocation cleanup before starting a job, default 1)',md.alloc_cleanup)); 
disp(sprintf('         waitonlock: %i      (wait for batch results 1, or return 0. default is to return )',md.waitonlock)); 
disp(sprintf('         queue: %s      (special queue name on cluster? default is '''')',md.queue));
disp(sprintf('      ''%s''','solver options'));
disp(sprintf('         %s','''ice'''));
disp(sprintf('            solver_type: %s      (solver type for Ice: ''lu'' or ''cholesky'')',md.solver_type));
disp(sprintf('         %s','''cielo'''));
disp(sprintf('            solverstring: %s (solver string for Petsc. See solversetto... routines. Default is asm)',md.solverstring)); 
