function md=cielomesh(md)
%INPUT function md=cielomesh(md)
%mesh solution

	%timing
	t1=clock;

	analysis='mesh';

	%configure, and initialise data model and parameter defaults:
	SetParameterDefaults;

	%first build an initial triangulation, using the domain outline and qhull.
	[md.elements,md.x,md.y,md.z]=MeshTriangulate(md);
	md.numberofgrids=length(md.x);
	md.numberofelements=length(md.elements);

	%timing
	t2=clock;
	disp(sprintf('\n%s\n',['   solution lasted ' num2str(etime(t2,t1)) ' seconds']));
