function WriteData(fid,data,data_type,name)
%WRITEDATA - ...
%
%   Usage:
%      WriteData(fid,data,data_type)

if issparse(data),
	data=full(data);
end

%Ok! put the length of the name, and the "name" string first!
fwrite(fid,length(name),'int'); 
fwrite(fid,name,'char'); 

if strcmpi(data_type,'String'),
	%first write length of record
	fwrite(fid,length(data)+4,'int');  %4 for int32
	%now write string
	fwrite(fid,length(data),'int'); 
	fwrite(fid,data,'char'); 
elseif strcmpi(data_type,'Mat'),
	s=size(data);
	
	%first write length of record
	fwrite(fid,4+4+8*s(1)*s(2),'int');  %2 integers (32 bits) + the double matrix

	%now write matrix
	fwrite(fid,s(1),'int'); 
	fwrite(fid,s(2),'int'); 
	if s(1)*s(2),
		fwrite(fid,data','double'); %get to the "c" convenction, hence the transpose
	end
elseif strcmpi(data_type,'Integer'),
	%first write length of record
	fwrite(fid,4,'int');  %1 integer
	%now write integer
	fwrite(fid,data,'int'); 
elseif strcmpi(data_type,'Scalar'),
	%first write length of record
	fwrite(fid,8,'int');  %1 double
	%now write double
	fwrite(fid,data,'double'); 
else 
	error('WriteData error message: data type not supported yet!');
end
