function expdisp(domainoutline,varargin)
%EXPDISP - plot the contours of a domain outline file
%
%   This routine reads in a domain outline file (Argus format) and plots all the contours 
%
%   Usage:
%      expdisp(domainoutline,varargin)
%
%   See also EXPMASTER, EXPDOC

if nargin==1,
	figurenumber=1;
	linestyle='r-';
end

if nargin==2,
	figurenumber=varargin{1};
	linestyle='r-';
end

if nargin==3,
	figurenumber=varargin{1};
	linestyle=varargin{2};
end

domain=expread(domainoutline,1);

figure(figurenumber),hold on
for i=1:length(domain),
	plot(domain(i).x,domain(i).y,linestyle);
end
