function dl1dl6=GetNodalFunctionsDerivativesParams(pentaelem,gauss_coord)
%GETNODALFUNCTIONSDERIVATIVESPARAMS - return the values of nodal functions derivatives on the reference element
%	
%   Usage:
%      dl1dl6=GetNodalFunctionsDerivativesParams(pentaelem,gauss_coord)
%
%   See also GETNODALFUNCTIONS, GETNODALFUNCTIONSDERIVATIVESBASIC, GETNODALFUNCTIONSDERIVATIVESPARAMSSTOKES

sqrt3=sqrt(3.0);

%Gauss point coordinate in reference element
r=gauss_coord(1,2) - gauss_coord(1,1);
s= - 3.0/sqrt3 *(gauss_coord(1,1)+gauss_coord(1,2) - 2.0/3.0);
zeta=gauss_coord(1,4);

num_grids=6;
dl1dl6=zeros(3,num_grids);

%First nodal function:
dl1dl6(1,1)=-1.0/2.0*(1-zeta)/2;
dl1dl6(2,1)=-sqrt3/6*(1-zeta)/2;
dl1dl6(3,1)=-1.0/2.0*(-1.0/2.0*r-sqrt3/6*s+1/3);

%Second nodal function:
dl1dl6(1,2)=1.0/2.0*(1-zeta)/2;
dl1dl6(2,2)=-sqrt3/6*(1-zeta)/2;
dl1dl6(3,2)=-1.0/2.0*(1.0/2.0*r-sqrt3/6*s+1/3);

%Third nodal function:
dl1dl6(1,3)=0;
dl1dl6(2,3)=sqrt3/3.0*(1-zeta)/2;
dl1dl6(3,3)=-1.0/2.0*(sqrt3/3.0*s+1/3);

%Fourth nodal function:
dl1dl6(1,4)=-1.0/2.0*(1+zeta)/2;
dl1dl6(2,4)=-sqrt3/6*(1+zeta)/2;
dl1dl6(3,4)=1.0/2.0*(-1.0/2.0*r-sqrt3/6*s+1/3);

%Fifth nodal function:
dl1dl6(1,5)=1.0/2.0*(1+zeta)/2;
dl1dl6(2,5)=-sqrt3/6*(1+zeta)/2;
dl1dl6(3,5)=1.0/2.0*(1.0/2.0*r-sqrt3/6*s+1/3);

%Sixth nodal function:
dl1dl6(1,6)=0;
dl1dl6(2,6)=sqrt3/3.0*(1+zeta)/2;
dl1dl6(3,6)=1.0/2.0*(sqrt3/3.0*s+1/3);

