function antoverlay2(fig1,fig2,alpha,colorbartitle,colmap,wrappingnumber);
%ANTOVERLAY2 - overlay a figure with image of Antarctica
%
%   Overlay figure1 image with Antarctica Power Image, and display on figure 2.
%   
%   Usage:
%      antoverlay2(fig1,fig2,alpha,colorbartitle,colmap,wrappingnumber,outlineflag,colorbarflag)

if ((nargin==0) || (nargin~=6)),
	help antoverlay;
	return;
end

%Capture image on figure fig1:
figure(fig1)

%Capture title
t=get(gca,'Title');
ti=get(t,'String');

%First remove tick marks
fig1xticks=get(gca,'XTick');
fig1yticks=get(gca,'YTick');
set(gca,'XTick',[]);
set(gca,'YTick',[]);

%Capture
im=frame2im(getframe);

%Capture max and min values
maxminvalues=caxis;
c1=maxminvalues(1);
c2=maxminvalues(2);

%flip image and rescale it.
red=im(:,:,1);
green=im(:,:,2);
blue=im(:,:,3);
im(:,:,1)=flipud(red);
im(:,:,2)=flipud(green);
im(:,:,3)=flipud(blue);

%Get Size of image
s=size(im);
s1=s(1);
s2=s(2);

%Get coordinates of image
xbound=xlim;
ybound=ylim;
x0=xbound(1);
x1=xbound(2);
y0=ybound(1);
y1=ybound(2);


%Create new image coordinates
x_m=x0:(x1-x0)/(s2-1):x1;
y_m=y0:(y1-y0)/(s1-1):y1;

%Now that image on figure fig1 is correctly setup, go fetch 
%the radar power image. 
path_gdal='/home/larour/gdal2/bin/';
%the geotiff image is either 200m or 1km accuracy. We take the 1km accuracy if the domain 
%of fig1  is more than 1000 km. 
geotiff_name='/proj/tpfimos/larour/Glaciology/Model_Data/Mosaic_Tiff/amm125m_v2_200m.tif';
if (max((x1-x0),(y1-y0))>1000000),
	geotiff_name='/proj/tpfimos/larour/Glaciology/Model_Data/Mosaic_Tiff/amm125m_v2_1km.tif';
end
inputname='./temp.tif';

command=['system(''' path_gdal 'gdal_translate -projwin ' num2str(x0) ' ' num2str(y1) ' ' num2str(x1) ' ' num2str(y0) ' ' geotiff_name ' ' inputname ''');'];
eval(command);

%Read in temp.tif:
radar=imread('temp.tif','TIFF');
save temp radar
r=size(radar);
r1=r(1);
r2=r(2);
x_r=x0:(x1-x0)/(r2-1):x1;
y_r=y0:(y1-y0)/(r1-1):y1;

%Display radar image first
figure(fig2)
set(fig2,'Position',[1604 4 1594 1123]);
rim=imagesc(x_r,y_r,flipud(radar));colormap('gray');
save temp x_r y_r
set(gca,'YDir','normal');

%Display captured image 
hold on
iim=image(x_m,y_m,im);
set(gca,'YDir','normal');

%Set transparency of data image
set(iim,'AlphaData',alpha);

%Set title identical to the one from fig1
title(ti,'Fontsize',18);

%x and y axis
xlabel('X (m)','FontSize',18);
ylabel('Y (m)','FontSize',18);

%Read in outline of antarctica and display. 
load /proj/tpfimos/larour/Glaciology/Model_Data/Mosaic_Tiff/antarctica_outline
outline_axes=axes('Position',[.15,.75,.15,.15]); 
imagesc(outlinex,outliney,outline);set(outline_axes,'YDir','normal');
set(outline_axes,'XTick',[]); set(outline_axes,'YTick',[]);
set(outline_axes,'XTickLabel',[]); set(outline_axes,'YTickLabel',[]);
hold on;
%build box inside the continent
for i=1:50,
	plot(x0:500:x1,(y0+500*i)*ones(length(x0:500:x1),1),'r');
	plot(x0:500:x1,(y1-500*i)*ones(length(x0:500:x1),1),'r');
	plot((x0+500*i)*ones(length(y0:500:y1),1),y0:500:y1,'r');
	plot((x1-500*i)*ones(length(y0:500:y1),1),y0:500:y1,'r');
end
%make border
for i=1:50,
	plot(min(outlinex):500:max(outlinex),(min(outliney)+500*i)*ones(length(min(outlinex):500:max(outlinex)),1),'w');
	plot(min(outlinex):500:max(outlinex),(max(outliney)-500*i)*ones(length(min(outlinex):500:max(outlinex)),1),'w');
	plot((min(outlinex)+500*i)*ones(length(min(outliney):500:max(outliney)),1),min(outliney):500:max(outliney),'w');
	plot((max(outlinex)-500*i)*ones(length(min(outliney):500:max(outliney)),1),min(outliney):500:max(outliney),'w');
end

%Build colorbar
colim=zeros(1,length(colmap),3);
colim(1,:,1)=colmap(:,1);
colim(1,:,2)=colmap(:,2);
colim(1,:,3)=colmap(:,3);
colaxes=axes('Position',[.7,.05,.1,.02]);
image(colim);
set(colaxes,'XTick',[]);
set(colaxes,'YTick',[]);
%t=text(length(colmap)/2,2,[num2str(c2/wrappingnumber) ' ' colorbartitle]);
t=text(0,0,num2str(c1));
set(t,'FontSize',16);
t=text(length(colmap),0,num2str(c2));
set(t,'FontSize',16);
t=text(length(colmap)/2,2,colorbartitle);
set(t,'HorizontalAlignment','center');
set(t,'FontSize',18);


%We are done, reeastablish figure fig1 settings
figure(fig1);
set(gca,'XTick',fig1xticks);
set(gca,'YTick',fig1yticks);

