/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

/**
 * \file DynamicGSS.h
 *
 * Defines the coliny::DynamicGSS class.
 */

#ifndef coliny_DynamicGPS_h
#define coliny_DynamicGPS_h

#include <acro_config.h>
#include <utilib/default_rng.h>
#include <utilib/Normal.h>
#include <colin/StdOptSolver.h>
#include <colin/BatchEvaluator.h>

namespace coliny {

using colin::real;
using utilib::BasicArray;
using utilib::Normal;
using utilib::NumArray;


/** An implemention of a dynamic generating set search method that
decomposes the search into subproblems.
*/
class DynamicGSS :
	public colin::StdOptSolver<BasicArray<double>,
				   colin::AppResponse_Utilib>, 
	protected colin::BatchEvaluator<colin::OptProblem<BasicArray<double>,
                                 		   colin::AppResponse_Utilib>,
               			 BasicArray<double> >
{
public:

  typedef colin::BatchEvaluator<colin::OptProblem<BasicArray<double>,response_t>, BasicArray<double> > batch_evaluator_t;

  ///
  DynamicGSS();

  ///
  void reset();

  ///
  void minimize();

  ///
  utilib::Normal nrnd;

protected:

  ///
  void initialize_best_point()
	{
	if ((best().point.size() > 0) &&
	    (best().point.size() != problem.num_real_params()))
	   EXCEPTION_MNGR(std::runtime_error, "initialize_best_point - user-provided best point has length " << best().point.size() << " but the problem size is " << problem.num_real_params() << std::endl);
        best().point.resize(problem.num_real_params());
	}

};

} // namespace coliny

#endif
