C***********************************************************************
C Dempster-Shafer Evidence Theory implementation.
C Sandia National Laboratories 2006.
C
C At the present time, the Dempster-Shafer Evidence Theory implementation 
C is being distributed as part of the DAKOTA framework, under the DAKOTA GNU
C GPL (see the README, COPYRIGHT, and LICENSE file in the top Dakota 
C directory for more information).
C***********************************************************************
      SUBROUTINE MINMAX(MAXINT,NCMB,NV,NI,IP,
     1     VMIN,VMAX,CMIN,CMAX,X,Y)
C      SUBROUTINE MINMAX(MAXV,MAXINT,MAXCMB,NV,NI,IP,
C     1     VMIN,VMAX,CMIN,CMAX,X,Y)
C*****EVALUATE MINIMUMS AND MAXIMUMS FOR COMBINATIONS
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C      DIMENSION NI(MAXV),IP(MAXCMB)
C      DIMENSION VMIN(MAXINT,MAXV),VMAX(MAXINT,MAXV),
C     1     CMIN(MAXCMB),CMAX(MAXCMB),X(MAXCMB)
      DIMENSION NI(NV),IP(NV)
      DIMENSION VMIN(MAXINT*NV),VMAX(MAXINT*NV),
     1     CMIN(NCMB),CMAX(NCMB),X(NV)
C      DO 25 IINT=1,MAXINT
C         DO 15 INNV=1,NV
C            WRITE(*,*) 'INTVL',IINT,'IINV',INNV,'VMIN',VMIN(IINT,INNV)
C            WRITE(*,*) 'INTVL',IINT,'IINV',INNV,'VMAX',VMAX(IINT,INNV)
C 15      CONTINUE
C 25   CONTINUE

C            WRITE(*,*) 'Y',Y
C      DO 45 IMCMB=1,MAXCMB
C            WRITE(*,*) 'COMBO ',IMCMB,'CMIN',CMIN(IMCMB)
C            WRITE(*,*) 'COMBO ',IMCMB,'CMAX',CMAX(IMCMB)
C            WRITE(*,*) 'COMBO',IMCMB,'Y',Y
C 45   CONTINUE


C
C*****INITIALIZE POINTER FOR FIRST VARIABLE TO ZERO
      IP(1)=0
C*****LOOP OVER VARIABLES AFTER FIRST VARIABLE
      DO 1000 IV=2,NV
C********INITIALIZE POINTER FOR CURRENT VARIABLE TO FIRST INPUT INTERVAL
         IP(IV)=1
 1000 CONTINUE
C*****LOOP OVER VARIABLES AFTER FIRST VARIABLE
      DO 3000 IV=2,NV
 2000    CONTINUE
C********CHECK FOR CURRENT VALUE WITHIN CURRENT INTERVAL
         IF ((X(IV) .LT. VMIN((IV-1)*MAXINT+IP(IV))) .OR.
     1       (X(IV) .GT. VMAX((IV-1)*MAXINT+IP(IV)))) THEN
C         IF ((X(IV) .LT. VMIN(IP(IV),IV)) .OR.
C     1       (X(IV) .GT. VMAX(IP(IV),IV))) THEN
C***********INCREMENT INTERVAL POINTER
            IP(IV)=IP(IV) + 1
C***********TERMINATE SUBROUTINE IF INITIAL INTERVAL NOT LOCATED
            IF (IP(IV) .GT. NI(IV)) RETURN
            GO TO 2000
         ENDIF
 3000 CONTINUE
C*****INITIALIZE VARIABLE POINTER
      IVT=1
C*****BEGINNING OF COMPUTATION LOOP FOR INPUT INTERVALS
 4000 CONTINUE
C*****INCREMENT INTERVAL POINTER FOR CURRENT VARIABLE
      IP(IVT)=IP(IVT) + 1
C*****WHEN VALUE OF INTERVAL POINTER FOR CURRENT VARIABLE EXCEEDS NUMBER OF
C*****INTERVALS, ATTEMPT TO INCREMENT INTERVAL POINTER FOR NEXT VARIABLE
      IF (IP(IVT) .GT. NI(IVT)) THEN
C********RESET INTERVAL POINTER FOR CURRENT VARIABLE TO FIRST INTERVAL
         IP(IVT)=1
 5000    CONTINUE
C********CHECK FOR CURRENT VALUE WITHIN CURRENT INTERVAL
C         IF ((X(IVT) .LT. VMIN(IP(IVT),IVT)) .OR.
C     1       (X(IVT) .GT. VMAX(IP(IVT),IVT))) THEN
         IF ((X(IVT) .LT. VMIN((IVT-1)*MAXINT+IP(IVT))) .OR.
     1       (X(IVT) .GT. VMAX((IVT-1)*MAXINT+IP(IVT)))) THEN
C***********INCREMENT INTERVAL POINTER
            IP(IVT)=IP(IVT) + 1
            GO TO 5000
         ENDIF
C********INCREMENT VARIABLE POINTER
         IVT=IVT + 1
C********TERMINATE LOOP WHEN VARIABLE POINTER EXCEEDS NUMBER OF VARIBLES
         IF (IVT .GT. NV) GO TO 8000
C********RE-EVALUATE INTERVAL POINTER FOR CURRENT VARIABLE
         GO TO 4000
      ENDIF
C*****CHECK FOR CURRENT VARIABLE WITHIN CURRENT INTERVAL
C      IF ((X(IVT) .LT. VMIN(IP(IVT),IVT)) .OR.
C     1    (X(IVT) .GT. VMAX(IP(IVT),IVT))) GO TO 4000
      IF ((X(IVT) .LT. VMIN((IVT-1)*MAXINT+IP(IVT))) .OR.
     1    (X(IVT) .GT. VMAX((IVT-1)*MAXINT+IP(IVT)))) GO TO 4000
C*****INITIALIZE COMBINATION INDEX
      ICMB=IP(1)
      IMULT=1
C*****LOOP OVER VARIABLES
      DO 6000 IV=2,NV
         IMULT=IMULT * NI(IV-1)
C********ACCUMULATE COMBINATION INDEX
         ICMB=ICMB + (IP(IV)-1)*IMULT
 6000 CONTINUE
C*****EVALUATE MINIMUM AND MAXIMUM VALUES
      CMIN(ICMB)=MIN(CMIN(ICMB),Y)
      CMAX(ICMB)=MAX(CMAX(ICMB),Y)
C*****REINITIALIZE VARIABLE POINTER
      IF (IVT .NE. 1) IVT=1
C*****SEARCH FOR NEXT COMBINATION
      GO TO 4000
 8000 CONTINUE
      RETURN
      END
