#Server Makefile configuration.
   
ifeq ($(cluster),1)

	#Undefine matlab if already defined. 
	CFLAGS+= -UMATLAB -D_CLUSTER_

	ifdef MPILAUNCH
		mpilaunch = $(MPILAUNCH)
	else
		mpilaunch= mpi
	endif

	ifeq ($(mpilaunch),bsub)
		CFLAGS   += -D_BSUB_
	endif
	ifeq ($(mpilaunch),mpi)
		CFLAGS   += -D_MPI_
	endif

	#MPIIO flags: 
	CFLAGS += -D_FILE_OFFSET_BITS=64 -D_LARGEFILE64_SOURCE=1 -D_LARGEFILE_SOURCE=1 -D_USE_LUSTRE_
	#CFLAGS += -D_FILE_OFFSET_BITS=64 

	#Server flags
	CFLAGS += -fno-strict-aliasing  -D_SERVER_ -O3

	#MPI
	COMPUTLIBS += -lmpi

	#SLEPC Definitions
	ifeq (slepc,$(findstring slepc,$(computlib)))
		SLEPCDIR=/home/larour/Libraries/slepc-2.3.2-intel
		CFLAGS += -I$(SLEPCDIR)/include
		#COMPUTLIBS += -L$(SLEPCDIR)/lib/$(PETSCARCH) -lslepc
	endif

	
	#PLAPACK Definitions.
	ifeq (plapack,$(findstring plapack,$(computlib)))
		PLAPACKDIR=$(PETSCROOT)/externalpackages/PLAPACKR32
		CFLAGS += -I$(PLAPACKDIR)/INCLUDE -I$(PETSCROOT)/src/mat/impls/dense/mpi/plapack/
		COMPUTLIBS += -L$(PLAPACKDIR)/$(PETSCARCH) -lPLAPACK
	endif

	#MUMPS Definitions.
	ifeq (mumps,$(findstring mumps,$(computlib)))
		MUMPSDIR=$(PETSCROOT)/externalpackages/MUMPS_4.6.3/
		CFLAGS += -I$(MUMPSDIR)/include 
		COMPUTLIBS += -L$(MUMPSDIR)/$(PETSCARCH)/lib -ldmumps -lcmumps -lpord
	endif

	#PETSC Definitions: 
	ifeq (petsc,$(findstring petsc,$(computlib)))
		#LAPACK and BLAS definitions needed for MPI use of Petsc.
		FBLASLAPACKDIR=/opt/intel/mkl/9.1.023/lib/64
		COMPUTLIBS += -L$(FBLASLAPACKDIR) -lmkl_lapack -lmkl -lguide 
	endif

	#SCALAPACK Definitions
	ifeq (scalapack,$(findstring scalapack,$(computlib)))
		SCALAPACKDIR=$(PETSC_DIR)/externalpackages/SCALAPACK/$(PETSC_ARCH)
		BLACSDIR=$(PETSC_DIR)/externalpackages/blacs-dev/$(PETSC_ARCH)
	
		COMPUTLIBS += -L$(SCALAPACKDIR) -lscalapack  -L$(BLACSDIR) -lblacs 
	endif

	#Extra definitions
	COMPUTLIBS += -L/usr/X11R6/lib -lX11  -L/opt/intel/fc/9.1.051/lib -lifcore
	
endif 

ifeq ($(batch),1)
#Add _BATCH_ flag to compilation
CFLAGS+= -D_BATCH_
endif
