/*!\file Rgb.c
 * \brief: implementation of the Rgb object
 */


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../DataSet/DataSet.h"
#include "./objects.h"

		
Rgb::Rgb(){
	return;
}
Rgb::Rgb(int rgb_id,int rgb_nodeid1,int rgb_nodeid2, int rgb_dof){

	id=rgb_id;
	nodeid1=rgb_nodeid1;
	nodeid2=rgb_nodeid2;
	dof=rgb_dof;

	return;
}

Rgb::~Rgb(){
	return;
}
		
void Rgb::Echo(void){

	printf("Rgb:\n");
	printf("   id: %i\n",id);
	printf("   nodeid1: %i\n",nodeid1);
	printf("   nodeid2: %i\n",nodeid2);
	printf("   dof: %i\n",dof);
	return;
}
		
void  Rgb::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of Rgb: */
	enum_type=RgbEnum();
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall Rgb data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&nodeid1,sizeof(nodeid1));marshalled_dataset+=sizeof(nodeid1);
	memcpy(marshalled_dataset,&nodeid2,sizeof(nodeid2));marshalled_dataset+=sizeof(nodeid2);
	memcpy(marshalled_dataset,&dof,sizeof(dof));marshalled_dataset+=sizeof(dof);

	*pmarshalled_dataset=marshalled_dataset;
	return;
}
		
int   Rgb::MarshallSize(){

	return sizeof(id)+
		sizeof(nodeid1)+
		sizeof(nodeid2)+
		sizeof(dof)+
		sizeof(int); //sizeof(int) for enum type
}

char* Rgb::GetName(void){
	return "rgb";
}
		

void  Rgb::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/

	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&nodeid1,marshalled_dataset,sizeof(nodeid1));marshalled_dataset+=sizeof(nodeid1);
	memcpy(&nodeid2,marshalled_dataset,sizeof(nodeid2));marshalled_dataset+=sizeof(nodeid2);
	memcpy(&dof,marshalled_dataset,sizeof(dof));marshalled_dataset+=sizeof(dof);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
int Rgb::Enum(void){

	return RgbEnum();

}
int    Rgb::GetId(void){ return id; }

int    Rgb::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}

int   Rgb::GetNodeId1(){
	
	return nodeid1;
}
int   Rgb::GetNodeId2(){
	
	return nodeid2;
}

int Rgb::GetDof(){
	return dof;
}
Object* Rgb::copy() {
	return new Rgb(*this); 
}

