function contour=CreateDomainOutline(numberofpoints,radius)
%This funtion returns the coordinates of points on a circular domain. There is numberofpoints points
%The radius of the circle is by default 1 but can change it.
%Radius is the radius of the circular domain you wish to create

if ((floor(numberofpoints)-numberofpoints)~=0)
	error('domainoutline argument must be a positive integer')
end

if ((radius-abs(radius))~=0)
	error('radius must be a positive number')
end

%Calculate the cartesians coordinates of the points
x_list=ones(numberofpoints,1);
y_list=ones(numberofpoints,1);

theta=(0:2*pi/numberofpoints:2*pi*(1-1/numberofpoints))';

x_list=radius*x_list.*cos(theta);
y_list=radius*y_list.*sin(theta);

contour.x=x_list;
contour.y=y_list;
contour.density=1;

end
