/*!\file ProcessParamsx
 * \brief: process parameters using partitioning vector
 */

#include "./ProcessParamsx.h"

#undef __FUNCT__ 
#define __FUNCT__ "ProcessParamsx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void ProcessParamsx( DataSet* parameters, Vec  part){

	int i;
	
	double* partition=NULL;
	Param*  param=NULL;
	double* vx_obs=NULL;
	double* vy_obs=NULL;
	double* control_parameter=NULL;
	int     numberofnodes;
	int     analysis_type;
	int     count;

	/*new parameters: */
	double* u_g_obs=NULL;
	double* p_g=NULL;

	parameters->FindParam((void*)&analysis_type,"analysis_type");
	count=parameters->Size();

	if(analysis_type==ControlAnalysisEnum()){

		/*First serialize partition vector: */
		VecToMPISerial(&partition,part);
		
		parameters->FindParam((void*)&vx_obs,"vx_obs");
		parameters->FindParam((void*)&vy_obs,"vy_obs");
		parameters->FindParam((void*)&control_parameter,"control_parameter");
		parameters->FindParam((void*)&numberofnodes,"numberofnodes");

		/*Now, from vx_obs and vy_obs, build u_g_obs, correctly partitioned: */
		u_g_obs=(double*)xcalloc(numberofnodes*2,sizeof(double));
		p_g=(double*)xcalloc(numberofnodes*2,sizeof(double));

		for(i=0;i<numberofnodes;i++){
			u_g_obs[(int)(partition[2*i+0]-1)]=vx_obs[i];  //C indexing
			u_g_obs[(int)(partition[2*i+1]-1)]=vy_obs[i];  //C indexing
			p_g[(int)(partition[2*i+0]-1)]=control_parameter[i];
		}

		/*Now, create new parameters: */
		count++;
		param= new Param(count,"u_g_obs",DOUBLEVEC);
		param->SetDoubleVec(u_g_obs,2*numberofnodes);
		parameters->AddObject(param);

		count++;
		param= new Param(count,"p_g",DOUBLEVEC);
		param->SetDoubleVec(p_g,2*numberofnodes);
		parameters->AddObject(param);
	}

	xfree((void**)&partition);
	xfree((void**)&vx_obs);
	xfree((void**)&vy_obs);
	xfree((void**)&control_parameter);
	xfree((void**)&u_g_obs);
	xfree((void**)&p_g); 
}
