%
%  populate a Dakota parameter structure.
%
%  [params]=dakota_in_params(params)
%
function [params]=dakota_in_params(params)

global ISSM_DIR;

if ~nargin
    help dakota_in_params
    return
end

%%  process the input parameters

if ~exist('params','var')
    params=struct();
end

%%  strategy section

if ~isfield(params,'graphics')
    params.graphics=false;
end
if ~isfield(params,'tabular_graphics_data')
    params.tabular_graphics_data=true;
end
% could use unique file name rather than dakota default
if ~isfield(params,'tabular_graphics_file')
    params.tabular_graphics_file='dakota_tabular.dat';
end

%%  method section

% if isfield(params,'method')
%     method=params.method;
% end

%  method-independent

if ~isfield(params,'output')
    params.output=false;
end
if ~isfield(params,'max_iterations')
    params.max_iterations=100;
end
if ~isfield(params,'max_function_evaluations')
    params.max_function_evaluations=100;
end
if ~isfield(params,'convergence_tolerance')
    params.convergence_tolerance=1.e-4;
end

%  nondeterministic methods

if ~isfield(params,'distribution')
    params.distribution='cumulative';
end
if ~isfield(params,'compute')
    params.compute='probabilities';
end

%  nond_sampling

if ~isfield(params,'seed')
    params.seed=1234;
end
if ~isfield(params,'samples')
    params.samples=100;
end
if ~isfield(params,'sample_type')
    params.sample_type='lhs';
end
if ~isfield(params,'all_variables')
    params.all_variables=false;
end
if ~isfield(params,'variance_based_decomp')
    params.variance_based_decomp=false;
end

%  nond_local_reliability

%%  interface section

if ~isfield(params,'asynchronous')
    params.asynchronous=true;
end
if ~isfield(params,'evaluation_concurrency')
    params.evaluation_concurrency=false;
end
if ~isfield(params,'analysis_driver')
    params.analysis_driver=[ISSM_DIR '/src/m/solutions/dakota/cielo_ice_script.sh'];
end
if ~isfield(params,'parameters_file')
    params.parameters_file='params.in';
end
if ~isfield(params,'results_file')
    params.results_file='results.out';
end
if ~isfield(params,'file_tag')
    params.file_tag=true;
end
if ~isfield(params,'file_save')
    params.file_save=true;
end
if ~isfield(params,'analysis_components')
    params.analysis_components='';
end

%%  responses section

%  gradient specifications dependent on method
% if ~isfield(params,'no_gradients')
%     params.no_gradients=false;
% end
if ~isfield(params,'numerical_gradients')
    params.numerical_gradients=true;
end
if ~isfield(params,'method_source')
    params.method_source='dakota';
end
if ~isfield(params,'interval_type')
    params.interval_type='forward';
end
if ~isfield(params,'fd_gradient_step_size')
    params.fd_gradient_step_size=0.001;
end
if ~isfield(params,'analytic_gradients')
    params.analytic_gradients=false;
end
%  mixed_gradients not fully implemented
if ~isfield(params,'mixed_gradients')
    params.mixed_gradients=false;
end
if ~isfield(params,'id_analytic_gradients')
    params.id_analytic_gradients=false;
end
if ~isfield(params,'id_numerical_gradients')
    params.id_numerical_gradients=false;
end
% if ~isfield(params,'no_hessians')
%     params.no_hessians=false;
% end

end

