/*
 * CreateElementsNodesAndMaterialsStressbalanceHoriz.c:
 */

#include "../../toolkits/toolkits.h"
#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "./ModelProcessorx.h"

void CreateElementsVerticesAndMaterials(Elements* elements,Vertices* vertices,Materials* materials,IoModel* iomodel,const int nummodels){

	/*Intermediary*/
	int i;
	int materials_type;
	bool control_analysis;
	bool dakota_analysis;

	/*Fetch parameters: */
	iomodel->Constant(&control_analysis,InversionIscontrolEnum);
	iomodel->Constant(&dakota_analysis,QmuIsdakotaEnum);
	iomodel->Constant(&materials_type,MaterialsEnum);

	/*Did we already create the elements? : */
	_assert_(elements->Size()==0);

	/*Create elements*/
	if(control_analysis)iomodel->FetchData(3,InversionControlParametersEnum,InversionMinParametersEnum,InversionMaxParametersEnum);
	switch(iomodel->meshelementtype){
		case TriaEnum:
			for(i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]) elements->AddObject(new Tria(i+1,i,i,iomodel,nummodels));
			}
			break;
		case TetraEnum:
			for(i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]) elements->AddObject(new Tetra(i+1,i,i,iomodel,nummodels));
			}
			break;
		case PentaEnum:
			iomodel->FetchData(2,MeshUpperelementsEnum,MeshLowerelementsEnum);
			for(i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]) elements->AddObject(new Penta(i+1,i,i,iomodel,nummodels));
			}
			break;
		default:
			_error_("Mesh not supported yet");
	}

	/*Create materials*/
	switch(materials_type){
		case MaticeEnum:
			iomodel->FetchDataToInput(elements,MaterialsRheologyBEnum);
			iomodel->FetchDataToInput(elements,MaterialsRheologyNEnum);
			for (i=0;i<iomodel->numberofelements;i++) if(iomodel->my_elements[i]) materials->AddObject(new Matice(i+1,i,iomodel));
			switch(iomodel->domaindim){
				case 2:
					elements->InputDuplicate(MaterialsRheologyBEnum,MaterialsRheologyBbarEnum);
					break;
				case 3:
					break;
				default:
					_error_("Mesh not supported yet");
			}
			break;
		case MatdamageiceEnum:
			iomodel->FetchDataToInput(elements,MaterialsRheologyBEnum);
			iomodel->FetchDataToInput(elements,MaterialsRheologyNEnum);
			iomodel->FetchDataToInput(elements,DamageDEnum);
			for (i=0;i<iomodel->numberofelements;i++) if(iomodel->my_elements[i]) materials->AddObject(new Matice(i+1,i,iomodel));
			switch(iomodel->domaindim){
				case 2:
					elements->InputDuplicate(MaterialsRheologyBEnum,MaterialsRheologyBbarEnum);
					elements->InputDuplicate(DamageDEnum,DamageDbarEnum);
					break;
				case 3:
					break;
				default:
					_error_("Mesh not supported yet");
			}
			break;
		default:
			_error_("Materials "<<EnumToStringx(materials_type)<<" not supported");
	}

	/*Free data: */
	iomodel->DeleteData(8,MeshUpperelementsEnum,MeshLowerelementsEnum,
				MaterialsRheologyBEnum,MaterialsRheologyNEnum,DamageDEnum,InversionControlParametersEnum,InversionMinParametersEnum,
				InversionMaxParametersEnum);

	/*Add new constant material property to materials, at the end: */
	materials->AddObject(new Matpar(iomodel->numberofelements+1,iomodel));//put it at the end of the materials

	/*Create vertices: */

	/*Fetch data:*/
	iomodel->FetchData(6,MeshXEnum,MeshYEnum,MeshZEnum,BaseEnum,ThicknessEnum,MaskIceLevelsetEnum);
	if (iomodel->domaintype == Domain3DsurfaceEnum) iomodel->FetchData(3,MeshLatEnum,MeshLongEnum,MeshREnum);
	
	CreateNumberNodeToElementConnectivity(iomodel);

	for(i=0;i<iomodel->numberofvertices;i++){
		if(iomodel->my_vertices[i]) vertices->AddObject(new Vertex(i+1,i,i,iomodel));
	}

	/*Free data: */
	iomodel->DeleteData(6,MeshXEnum,MeshYEnum,MeshZEnum,BaseEnum,ThicknessEnum,MaskIceLevelsetEnum);
	if (iomodel->domaintype == Domain3DsurfaceEnum) iomodel->DeleteData(3,MeshLatEnum,MeshLongEnum,MeshREnum);
}
